/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.rest.entity;

import com.atlassian.bitbucket.internal.search.common.settings.SearchServerConfiguration;
import com.atlassian.bitbucket.internal.search.common.settings.rest.entity.RestConfigurableProperty;
import com.atlassian.bitbucket.internal.search.common.settings.rest.entity.RestSearchServerConfiguration;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonSerialize
public class RestSearchServerConfigurationResponse
extends RestSearchServerConfiguration {
    public RestSearchServerConfigurationResponse() {
    }

    public RestSearchServerConfigurationResponse(SearchServerConfiguration configuration) {
        this.put("awsRegion", (Object)new RestConfigurableProperty(configuration.getAwsRegion()));
        this.put("url", (Object)new RestConfigurableProperty(configuration.getBaseUrl()));
        this.put("username", (Object)new RestConfigurableProperty(configuration.getUsername()));
        this.put("password", (Object)new RestConfigurableProperty(configuration.getPassword()));
    }

    @Schema(description="The AWS region configuration for the search server instance", example="{\"value\": \"us-east-2\", \"configuredAt\": \"DATABASE\"}", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public RestConfigurableProperty getAwsRegion() {
        return RestConfigurableProperty.valueOf(this.get("awsRegion"));
    }

    @Schema(description="The base URL for the search server instance", example="{\"value\": \"http://localhost:9200\", \"configuredAt\": \"PROPERTIES\"}", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public RestConfigurableProperty getBaseUrl() {
        return RestConfigurableProperty.valueOf(this.get("url"));
    }

    @Schema(description="The password configuration for the search server instance authentication. For security reasons, the actual password value is not exposed in the response. However, if a password is configured, 'configuredAt' will specify where it was set, while the 'value' field will be null.", example="{\"configuredAt\": \"PROPERTIES\"}", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public RestConfigurableProperty getPassword() {
        return RestConfigurableProperty.valueOf(this.get("password"));
    }

    @Schema(description="The username configuration for the search server instance authentication", example="{\"value\": \"admin\", \"configuredAt\": \"DATABASE\"}", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public RestConfigurableProperty getUsername() {
        return RestConfigurableProperty.valueOf(this.get("username"));
    }
}

