/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.settings.tester;

import com.atlassian.bitbucket.internal.search.common.clientutil.SearchClientFactory;
import com.atlassian.bitbucket.internal.search.common.settings.SearchSettingsAccessor;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionResult;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionTester;
import com.atlassian.bitbucket.internal.search.common.settings.tester.TestSearchRequestBuilder;
import com.atlassian.bitbucket.internal.search.common.settings.tester.TestSearchResponse;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.internal.search.version.SearchVersionUtils;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.elasticsearch.client.Client;
import com.atlassian.elasticsearch.client.request.RequestBuilder;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import software.amazon.awssdk.core.exception.SdkClientException;

@Component
public class DefaultSearchConnectionTester
implements SearchConnectionTester {
    private static final Logger log = LoggerFactory.getLogger(DefaultSearchConnectionTester.class);
    private final SearchClientFactory clientFactory;
    private final EscalatedSecurityContext withSysAdmin;

    @Autowired
    public DefaultSearchConnectionTester(SearchClientFactory clientFactory, SecurityService securityService) {
        this.clientFactory = clientFactory;
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "Create search client");
    }

    @Override
    @Nonnull
    public SearchConnectionResult testConnection(@Nonnull SearchSettingsAccessor searchSettings) {
        Objects.requireNonNull(searchSettings, "searchSettings");
        try (Client client = (Client)this.withSysAdmin.call(() -> this.clientFactory.create(searchSettings));){
            CompletableFuture future = client.execute((RequestBuilder)new TestSearchRequestBuilder());
            SearchConnectionResult searchConnectionResult = (SearchConnectionResult)((Object)((CompletableFuture)((CompletableFuture)future.thenApply(this::determineResult)).exceptionally(this::determineResult)).join());
            return searchConnectionResult;
        }
    }

    private SearchConnectionResult determineResult(TestSearchResponse response) {
        if (response.isStatusSuccess()) {
            return response.getVersion().map(versionString -> {
                String distributionString = response.getDistribution().orElse(null);
                SearchVersion searchVersion = SearchVersionUtils.getVersionFactory(distributionString, versionString).create();
                if (!searchVersion.isSupported()) {
                    log.error("Connected to an unsupported search server version: {} {}", (Object)searchVersion.getDistribution().getName(), versionString);
                    return SearchConnectionResult.UNSUPPORTED_VERSION;
                }
                log.debug("Connected to search server {} {}", (Object)searchVersion.getDistribution().getName(), versionString);
                return SearchConnectionResult.SUCCESS;
            }).orElseGet(() -> {
                log.debug("Attempt to connect to the search server failed: Unable to find 'version.number' field in response");
                return SearchConnectionResult.APPLICATION_ERROR;
            });
        }
        int statusCode = response.getStatusCode();
        log.debug("Testing connection with search server failed: HTTP response status code is {}", (Object)statusCode);
        if (statusCode == Response.Status.UNAUTHORIZED.getStatusCode() || statusCode == Response.Status.FORBIDDEN.getStatusCode()) {
            return SearchConnectionResult.AUTHENTICATION_ERROR;
        }
        log.debug("Testing connection with search server failed due to an unknown error.");
        if (log.isTraceEnabled()) {
            log.trace("Response: {}", (Object)response.getContent());
        }
        return SearchConnectionResult.UNKNOWN_ERROR;
    }

    private SearchConnectionResult determineResult(Throwable throwable) {
        log.debug("Testing connection with search server failed due to exception: ", throwable);
        if (throwable.getCause() instanceof SdkClientException) {
            return SearchConnectionResult.AWS_KEYCHAIN_ERROR;
        }
        return SearchConnectionResult.CONNECTION_ERROR;
    }
}

