/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.upgrade;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.secrets.DmzSecretService;
import com.atlassian.bitbucket.dmz.secrets.SecretNamespace;
import com.atlassian.bitbucket.dmz.secrets.SecretServiceConfig;
import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.PluginSettingsProvider;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="migrateSearchPasswordUpgradeTask")
public class MigrateSearchPasswordUpgradeTask {
    static final String KEY_TASK = "plugin.search.migrate-search-password";
    private static final Logger log = LoggerFactory.getLogger(MigrateSearchPasswordUpgradeTask.class);
    private final LockService lockService;
    private final PluginSettings pluginSettings;
    private final DmzSecretService secretService;
    private final SecretServiceConfig secretServiceConfig;

    @Autowired
    public MigrateSearchPasswordUpgradeTask(LockService lockService, PluginSettingsProvider pluginSettingsProvider, DmzSecretService secretService, SecretServiceConfig secretServiceConfig) {
        this.lockService = lockService;
        this.pluginSettings = pluginSettingsProvider.getPluginSettings();
        this.secretService = secretService;
        this.secretServiceConfig = secretServiceConfig;
    }

    @PostConstruct
    public void runUpgrade() {
        if (this.secretServiceConfig.isDisabled()) {
            log.debug("Skipping upgrade task as secret service is disabled");
            return;
        }
        if (this.isAlreadyMigrated()) {
            log.debug("Skipping upgrade task as the search password has already been migrated into secret storage");
            return;
        }
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(KEY_TASK));){
            log.debug("Locked upgrade task {}", (Object)KEY_TASK);
            if (this.isAlreadyMigrated()) {
                log.debug("Skipping upgrade task as the search password has already been migrated into secret storage");
                return;
            }
            this.doUpgrade();
        }
    }

    private void doUpgrade() {
        log.info("Starting upgrade task {}", (Object)KEY_TASK);
        String existingPassword = (String)this.pluginSettings.get(PluginProperty.PASSWORD.getSettingKey());
        if (StringUtils.isNotBlank((CharSequence)existingPassword)) {
            this.secretService.put(SecretNamespace.INTERNAL, PluginProperty.PASSWORD.getSettingKey(), existingPassword);
        }
        this.pluginSettings.put(PluginProperty.PASSWORD.getSettingKey(), (Object)"{ATL_SECURED}");
        log.info("Upgrade task {} completed", (Object)KEY_TASK);
    }

    private boolean isAlreadyMigrated() {
        return "{ATL_SECURED}".equals(this.pluginSettings.get(PluginProperty.PASSWORD.getSettingKey()));
    }
}

