/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.util;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class Filenames {
    public static List<String> getExtensions(@Nonnull String path) {
        String part;
        int leftDot;
        Objects.requireNonNull(path, "path");
        String filename = Filenames.getFilename(path);
        ImmutableList.Builder extensions = ImmutableList.builder();
        int rightDot = Integer.MAX_VALUE;
        for (int i = 0; i < 3 && (leftDot = filename.lastIndexOf(46, rightDot - 1)) > 0 && !(part = filename.substring(leftDot + 1, Math.min(rightDot, filename.length()))).isEmpty() && part.length() <= 15 && (rightDot == Integer.MAX_VALUE || part.equals(part.toLowerCase(Locale.US)) || part.equals(part.toUpperCase(Locale.US))) && !part.chars().anyMatch(ch -> ch != 43 && !Character.isAlphabetic(ch) && !Character.isDigit(ch)); ++i) {
            extensions.add((Object)filename.substring(leftDot + 1));
            rightDot = leftDot;
        }
        return extensions.build();
    }

    @Nonnull
    public static String getFilename(@Nonnull String path) {
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return path;
        }
        return path.substring(slash + 1);
    }

    @Nonnull
    public static Optional<String> getParent(@Nonnull String path) {
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return Optional.empty();
        }
        return Optional.of(path.substring(0, slash));
    }
}

