/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.common.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class PropertyUtils {
    private PropertyUtils() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " only contains static utility methods and should not be instantiated.");
    }

    public static Multimap<String, String> getPropertiesAsMultiMap(Class<?> klass, String resourceName) {
        return PropertyUtils.getPropertiesAsMultiMap(klass, resourceName, ",");
    }

    public static Multimap<String, String> getPropertiesAsMultiMap(Class<?> klass, String resourceName, String valueSeparator) {
        HashMultimap propertyMap = HashMultimap.create();
        Properties properties = new Properties();
        try (InputStream inputStream = klass.getClassLoader().getResourceAsStream(resourceName);){
            properties.load(inputStream);
            properties.stringPropertyNames().forEach(arg_0 -> PropertyUtils.lambda$getPropertiesAsMultiMap$0(properties, valueSeparator, (Multimap)propertyMap, arg_0));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("%s properties file is missing from %s classpath.", resourceName, klass.getName()), e);
        }
        return propertyMap;
    }

    private static /* synthetic */ void lambda$getPropertiesAsMultiMap$0(Properties properties, String valueSeparator, Multimap propertyMap, String property) {
        List<String> propertyValues = Arrays.asList(properties.getProperty(property).split(String.format("\\s*%s\\s*", valueSeparator)));
        propertyMap.putAll((Object)property, propertyValues);
    }
}

