/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing;

import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexingSettings;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import jakarta.annotation.Nullable;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexingProperties {
    static final Duration DEFAULT_INDEXING_BROKEN_REPO_CLEANUP_JOB_INTERVAL = Duration.ofDays(1L);
    static final Duration DEFAULT_INDEXING_EVENT_DEQUEUE_TIMEOUT = Duration.ofSeconds(2L);
    static final Duration DEFAULT_INDEXING_EVENT_ENQUEUE_TIMEOUT = Duration.ofSeconds(2L);
    static final int DEFAULT_INDEXING_EVENT_QUEUE_SIZE = 50000;
    static final Duration DEFAULT_INDEXING_EVENT_SHUTDOWN_TIMEOUT = Duration.ofSeconds(2L);
    static final Duration DEFAULT_INDEXING_EXECUTION_TIMEOUT = Duration.ofMinutes(60L);
    static final Duration DEFAULT_INDEXING_IDLE_TIMEOUT = Duration.ofMinutes(5L);
    static final int DEFAULT_INDEXING_MAX_TEXT_FILE_SIZE = 524288;
    static final Duration DEFAULT_INDEXING_MONITORING_UNRESPONSIVE_TIMEOUT = Duration.ofMinutes(30L);
    static final String INDEXING_BROKEN_REPO_CLEANUP_JOB_INTERVAL = "plugin.search.indexing.broken.repository.cleanup.interval";
    static final String INDEXING_CODE_ENABLED_KEY = "plugin.search.codesearch.indexing.enabled";
    static final String INDEXING_CODE_EXCLUDE_KEY = "plugin.search.codesearch.indexing.exclude";
    static final String INDEXING_EVENT_QUEUE_DEQUEUE_TIMEOUT = "plugin.search.indexing.event.dequeue.timeout";
    static final String INDEXING_EVENT_QUEUE_ENQUEUE_TIMEOUT = "plugin.search.indexing.event.enqueue.timeout";
    static final String INDEXING_EVENT_QUEUE_SHUTDOWN_TIMEOUT = "plugin.search.indexing.event.shutdown.timeout";
    static final String INDEXING_EVENT_QUEUE_SIZE = "plugin.search.indexing.event.queue.size";
    static final String INDEXING_HTTP_CLIENT_KEEP_ALIVE_IDLE_TIMEOUT_KEY = "plugin.search.indexing.http.keepalive.idle.timeout";
    static final String INDEXING_HTTP_CONNECTION_POOL_TIMEOUT_KEY = "plugin.search.indexing.connection.pool.timeout";
    static final String INDEXING_HTTP_CONNECTION_TIMEOUT_KEY = "plugin.search.indexing.http.connection.timeout";
    static final String INDEXING_HTTP_SOCKET_TIMEOUT_KEY = "plugin.search.indexing.http.socket.timeout";
    static final String INDEXING_MAX_TEXT_FILE_SIZE_KEY = "plugin.search.indexing.max.text.file.size.bytes";
    static final String INDEXING_MONITORING_UNRESPONSIVE_TIMEOUT = "plugin.search.indexing.monitoring.unresponsive.timeout";
    static final String INDEXING_TIMEOUT_EXECUTION_KEY = "plugin.search.indexing.process.timeout.execution";
    static final String INDEXING_TIMEOUT_IDLE_KEY = "plugin.search.indexing.process.timeout.idle";
    private static final Duration DEFAULT_INDEXING_HTTP_CLIENT_KEEP_ALIVE_IDLE_TIMEOUT = Duration.ofMinutes(30L);
    private static final Duration DEFAULT_INDEXING_HTTP_CONNECTION_POOL_TIMEOUT = Duration.ofSeconds(15L);
    private static final Duration DEFAULT_INDEXING_HTTP_CONNECTION_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration DEFAULT_INDEXING_HTTP_SOCKET_TIMEOUT = Duration.ofSeconds(60L);
    private static final String PLUGIN = "plugin.";
    private final ApplicationPropertiesService applicationPropertiesService;

    @Autowired
    public IndexingProperties(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    public Duration getBrokenRepositoryCleanupJobInterval() {
        long timeout = this.applicationPropertiesService.getPluginProperty(INDEXING_BROKEN_REPO_CLEANUP_JOB_INTERVAL, 0L);
        if (timeout > 0L) {
            return Duration.ofDays(timeout);
        }
        return DEFAULT_INDEXING_BROKEN_REPO_CLEANUP_JOB_INTERVAL;
    }

    public boolean getCodeIndexingEnabled() {
        return this.applicationPropertiesService.getPluginProperty(INDEXING_CODE_ENABLED_KEY, true);
    }

    @Nullable
    public String getCodeIndexingExcludes() {
        return this.applicationPropertiesService.getPluginProperty(INDEXING_CODE_EXCLUDE_KEY, null);
    }

    public Duration getHttpConnectionPoolTimeout() {
        return this.getDurationOrDefault(INDEXING_HTTP_CONNECTION_POOL_TIMEOUT_KEY, DEFAULT_INDEXING_HTTP_CONNECTION_POOL_TIMEOUT);
    }

    public Duration getHttpConnectionTimeout() {
        return this.getDurationOrDefault(INDEXING_HTTP_CONNECTION_TIMEOUT_KEY, DEFAULT_INDEXING_HTTP_CONNECTION_TIMEOUT);
    }

    public Duration getHttpKeepAliveIdleTimeout() {
        return this.getDurationOrDefault(INDEXING_HTTP_CLIENT_KEEP_ALIVE_IDLE_TIMEOUT_KEY, DEFAULT_INDEXING_HTTP_CLIENT_KEEP_ALIVE_IDLE_TIMEOUT);
    }

    public Duration getHttpSocketTimeout() {
        return this.getDurationOrDefault(INDEXING_HTTP_SOCKET_TIMEOUT_KEY, DEFAULT_INDEXING_HTTP_SOCKET_TIMEOUT);
    }

    public Duration getIndexingEventDequeueTimeout() {
        return this.getDurationOrDefault(INDEXING_EVENT_QUEUE_DEQUEUE_TIMEOUT, DEFAULT_INDEXING_EVENT_DEQUEUE_TIMEOUT);
    }

    public Duration getIndexingEventEnqueueTimeout() {
        return this.getDurationOrDefault(INDEXING_EVENT_QUEUE_ENQUEUE_TIMEOUT, DEFAULT_INDEXING_EVENT_ENQUEUE_TIMEOUT);
    }

    public int getIndexingEventQueueSize() {
        return this.applicationPropertiesService.getPluginProperty(INDEXING_EVENT_QUEUE_SIZE, 50000);
    }

    public Duration getIndexingEventShutdownTimeout() {
        return this.getDurationOrDefault(INDEXING_EVENT_QUEUE_SHUTDOWN_TIMEOUT, DEFAULT_INDEXING_EVENT_SHUTDOWN_TIMEOUT);
    }

    public int getIndexingMaxTextFileSize() {
        return this.applicationPropertiesService.getPluginProperty(INDEXING_MAX_TEXT_FILE_SIZE_KEY, 524288);
    }

    public Duration getIndexingMonitoringUnresponsiveTimeout() {
        return this.getDurationOrDefault(INDEXING_MONITORING_UNRESPONSIVE_TIMEOUT, DEFAULT_INDEXING_MONITORING_UNRESPONSIVE_TIMEOUT);
    }

    public Duration getIndexingProcessExecutionTimeout() {
        return this.getDurationOrDefault(INDEXING_TIMEOUT_EXECUTION_KEY, DEFAULT_INDEXING_EXECUTION_TIMEOUT);
    }

    public Duration getIndexingProcessIdleTimeout() {
        return this.getDurationOrDefault(INDEXING_TIMEOUT_IDLE_KEY, DEFAULT_INDEXING_IDLE_TIMEOUT);
    }

    public IndexingSettings getIndexingSettings() {
        return IndexingSettings.builder().batchContentSizeBytes(this.applicationPropertiesService.getPluginProperty("plugin.search.indexing.max.batch.size", 0xF00000)).claimDuration(this.getDurationOrDefault("plugin.search.indexing.claim.duration", IndexingSettings.DEFAULT_CLAIM_DURATION)).indexRetries(this.applicationPropertiesService.getPluginProperty("plugin.search.indexing.operation.retries", 5)).itemsPerBatch(this.applicationPropertiesService.getPluginProperty("plugin.search.indexing.max.batch.items", 1000)).build();
    }

    private Duration getDurationOrDefault(String pluginPropertyKey, Duration defaultDuration) {
        long timeout = this.applicationPropertiesService.getPluginProperty(pluginPropertyKey, 0L);
        if (timeout > 0L) {
            return Duration.ofSeconds(timeout);
        }
        return defaultDuration;
    }
}

