/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing;

import com.atlassian.bitbucket.internal.search.SearchException;
import com.atlassian.bitbucket.internal.search.client.VersionCachingSearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.MappingType;
import com.atlassian.bitbucket.internal.search.common.mapping.ProjectMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexAdministrationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexCreationResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexValidationResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.ResponseStatus;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.ComparisonCallback;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.EntityWithLocation;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.SearchEntitySource;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.ServerEntitySource;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.StreamingComparator;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersionService;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersions;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.UpgradeService;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.indexing.util.SearchUtil;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.elasticsearch.client.search.Hit;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import rx.Observable;

@Service
public class IndexingSynchronizationService {
    private static final int MAX_PAGE_SIZE = 50;
    private static final Logger log = LoggerFactory.getLogger(IndexingSynchronizationService.class);
    private final VersionCachingSearchClient searchClient;
    private final IndexAdministrationService indexAdministrationService;
    private final IndexVersionService indexVersionService;
    private final ComparisonCallback<Integer> projectMetadataCallback;
    private final ComparisonCallback<Integer> repositoryContentCallback;
    private final ComparisonCallback<Integer> repositoryMetadataCallback;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final UpgradeService upgradeService;

    @Autowired
    public IndexingSynchronizationService(VersionCachingSearchClient searchClient, IndexAdministrationService indexAdministrationService, IndexVersionService indexVersionService, @Qualifier(value="projectMetadataCallback") ComparisonCallback<Integer> projectMetadataCallback, @Qualifier(value="repositoryContentCallback") ComparisonCallback<Integer> repositoryContentCallback, @Qualifier(value="repositoryMetadataCallback") ComparisonCallback<Integer> repositoryMetadataCallback, RepositoryService repositoryService, SecurityService securityService, UpgradeService upgradeService) {
        this.searchClient = searchClient;
        this.indexAdministrationService = indexAdministrationService;
        this.indexVersionService = indexVersionService;
        this.projectMetadataCallback = projectMetadataCallback;
        this.repositoryContentCallback = repositoryContentCallback;
        this.repositoryMetadataCallback = repositoryMetadataCallback;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.upgradeService = upgradeService;
    }

    public boolean synchronizeStores() {
        this.searchClient.clearVersionCache();
        if (!this.synchronizeMapping()) {
            return false;
        }
        return this.synchronizeProjects() && this.synchronizeRepositories(this.repositoryMetadataCallback) && this.synchronizeRepositories(this.repositoryContentCallback);
    }

    @VisibleForTesting
    boolean synchronizeMapping() {
        try {
            if (this.isMappingPresent()) {
                if (!this.upgradeService.upgrade()) {
                    log.error("Upgrading index failed, unable to continue, operator intervention is required.");
                    return false;
                }
                if (this.checkMapping()) {
                    log.debug("Mapping in the search server is present and valid");
                    return true;
                }
                log.error("Mapping in the search server is present but not compatible with this version of indexing. Unable to continue, operator intervention is required.");
                return false;
            }
            if (this.createMapping()) {
                this.indexVersionService.setCurrentVersion(IndexVersions.LATEST_VERSION);
                log.info("Mapping in the search server has been created successfully");
                return true;
            }
            log.error("Unable to synchronize the mapping in the search server");
        }
        catch (IndexException e) {
            if (SearchUtil.isNetworkConnectException(e)) {
                log.warn("Unable to establish a connection to the search server during index synchronisation.");
            }
            log.error("An error was encountered while checking or creating the mapping in the search server", (Throwable)e);
        }
        return false;
    }

    @VisibleForTesting
    boolean synchronizeProjects() {
        return (Boolean)this.securityService.withPermission(Permission.REPO_READ, "Indexing needs REPO_READ access").call(() -> {
            Observable projectObservable = Observable.from((Iterable)new PagedIterable(arg_0 -> ((RepositoryService)this.repositoryService).findAll(arg_0), 50)).map(Repository::getProject).distinct();
            return this.compareEntityStreams(this.projectMetadataCallback, hit -> Integer.parseInt(hit.getId()), Integer::intValue, projectObservable, Project::getId, ProjectMapping.type(), Optional.empty());
        });
    }

    @VisibleForTesting
    boolean synchronizeRepositories(ComparisonCallback<Integer> comparisonCallback) {
        return (Boolean)this.securityService.withPermission(Permission.REPO_READ, "Indexing needs REPO_READ access").call(() -> {
            Observable repositoryObservable = Observable.from((Iterable)new PagedIterable(arg_0 -> ((RepositoryService)this.repositoryService).findAll(arg_0), 50));
            return this.compareEntityStreams(comparisonCallback, hit -> Integer.parseInt(hit.getId()), Integer::intValue, repositoryObservable, Repository::getId, RepositoryMapping.type(), Optional.empty());
        });
    }

    private boolean checkMapping() throws IndexException {
        log.debug("Attempting to validate mapping in the search server");
        Observable<IndexValidationResult> validateMapping = this.indexAdministrationService.validateCodeSearchMapping();
        return (Boolean)Observables.consumeSingle(validateMapping).fold(e -> {
            throw new IndexException("Unable to validate mapping in the search server", (Throwable)e);
        }, indexValidationResult -> {
            if (indexValidationResult.getResponseStatus() == ResponseStatus.SUCCESS) {
                Map<MappingType, List<String>> validationErrors = indexValidationResult.getValidationErrors();
                validationErrors.forEach((key, value) -> log.error("The mapping for type '{}/{}' in the search server is invalid. Errors: {}", new Object[]{key.indexName(), key.typeName(), value}));
                return validationErrors.isEmpty();
            }
            throw new IndexException("Unable to validate mapping in the search server, returned failure status code: " + String.valueOf((Object)indexValidationResult.getResponseStatus()));
        });
    }

    private <T, U> boolean compareEntityStreams(ComparisonCallback<T> comparisonCallback, Function<Hit, T> hitToEntityConverter, Function<T, Integer> entityToIdentifierConverter, Observable<U> serverEntityObservable, Function<U, T> serverToEntityConverter, MappingType searchType, Optional<Function<Hit, Boolean>> searchFilter) {
        SearchEntitySource.Builder searchEntitySourceBuilder = SearchEntitySource.builder().searchClient(this.searchClient).hitToEntity(hitToEntityConverter).mappingType(searchType).pageSize(50);
        searchFilter.ifPresent(searchEntitySourceBuilder::filter);
        SearchEntitySource searchEntitySource = searchEntitySourceBuilder.build();
        ServerEntitySource serverEntitySource = ServerEntitySource.builder().dbObservable(serverEntityObservable).dbToEntity(serverToEntityConverter).build();
        return this.compareObservables(comparisonCallback, entityToIdentifierConverter, searchEntitySource.streamEntities(), serverEntitySource.streamEntities());
    }

    private <T, U> boolean compareObservables(ComparisonCallback<T> comparisonCallback, Function<T, U> entityToIdentifierConverter, Observable<EntityWithLocation<T>> searchEntitySource, Observable<EntityWithLocation<T>> serverEntitySource) {
        StreamingComparator streamingComparator = StreamingComparator.builder().entityToIdentifier(entityToIdentifierConverter).searchSource(searchEntitySource).serverSource(serverEntitySource).build();
        return streamingComparator.doComparison(comparisonCallback);
    }

    private boolean createMapping() throws IndexException {
        log.debug("Attempting to create mapping in the search server");
        Observable<IndexCreationResult> createResults = this.indexAdministrationService.createCodeSearchIndexes();
        ArrayList errors = new ArrayList();
        Observables.consume(createResults, e -> {
            if (!(e instanceof SearchException)) {
                log.error("Failed to create index", e);
            }
            errors.add(e.getMessage());
        }, created -> {
            if (created.getResponseStatus() != ResponseStatus.SUCCESS) {
                errors.add(created.getErrorType().orElse("Unknown error"));
            }
        });
        if (!errors.isEmpty()) {
            log.error("Failed to create indexes: ''{}''", errors);
            return false;
        }
        return true;
    }

    private boolean isMappingPresent() throws IndexException {
        Observable<Boolean> doesMappingExist = this.indexAdministrationService.codeSearchMappingExists();
        return (Boolean)Observables.consumeSingle(doesMappingExist).fold(e -> {
            throw new IndexException("Unable to check whether a valid mapping exists in the search server", (Throwable)e);
        }, Function.identity());
    }
}

