/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.administration;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexStateMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.MappingField;
import com.atlassian.bitbucket.internal.search.common.mapping.MappingType;
import com.atlassian.bitbucket.internal.search.common.mapping.ProjectMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.common.util.Optionals;
import com.atlassian.bitbucket.internal.search.indexing.administration.DefaultIndexConfigurationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexAdministrationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexConfigurationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexCreationResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexDeletionResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexSettingsResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexValidationResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.ResponseStatus;
import com.atlassian.bitbucket.internal.search.indexing.administration.UpdateMappingRequest;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.content.ContentBuilder;
import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.indices.CreateIndexRequestBuilder;
import com.atlassian.elasticsearch.client.indices.IndexExistsBuilder;
import com.atlassian.elasticsearch.client.indices.IndexExistsResponse;
import com.atlassian.elasticsearch.client.indices.IndexMappingResponse;
import com.atlassian.elasticsearch.client.indices.IndexSettingsBuilder;
import com.atlassian.elasticsearch.client.indices.IndexSettingsResponse;
import com.atlassian.elasticsearch.client.indices.MappingBuilder;
import com.atlassian.elasticsearch.client.indices.PutMappingRequestBuilder;
import com.atlassian.elasticsearch.client.indices.PutMappingResponse;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DefaultIndexAdministrationService
implements IndexAdministrationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexAdministrationService.class);
    private final SearchClient client;
    private final IndexConfigurationService configurationService;

    public DefaultIndexAdministrationService(@Nonnull SearchClient client, @Nonnull IndexConfigurationService configurationService) {
        this.client = Objects.requireNonNull(client, "client");
        this.configurationService = Objects.requireNonNull(configurationService, "configurationService");
    }

    public DefaultIndexAdministrationService(@Nonnull SearchClient client) {
        this(client, new DefaultIndexConfigurationService());
    }

    @Override
    public Observable<Boolean> codeSearchMappingExists() {
        IndexExistsBuilder builder = ES.index((String)FileMapping.type().indexName()).exists();
        return this.client.execute(builder).map(IndexExistsResponse::indexExists);
    }

    @Override
    public Observable<IndexCreationResult> createCodeSearchIndexes() {
        return this.client.getVersion().flatMap(version -> {
            DefaultIndexAdministrationService.failIfRunningOldVersion(version);
            Observable<IndexCreationResult> repoIndexResult = this.createIndex(RepositoryMapping.type(), this.configurationService.getEntityIndexSettings(), this.configurationService.getMappingForRepositoryType((SearchVersion)version));
            Observable<IndexCreationResult> projectIndexResult = this.createIndex(ProjectMapping.type(), this.configurationService.getEntityIndexSettings(), this.configurationService.getMappingForProjectType((SearchVersion)version));
            Observable<IndexCreationResult> indexStateIndexResult = this.createIndex(IndexStateMapping.type(), this.configurationService.getStateIndexSettings(), this.configurationService.getMappingForIndexStateType((SearchVersion)version));
            CreateIndexRequestBuilder builder = ES.index((String)FileMapping.type().indexName()).create().source((ContentBuilder)ES.createIndexSource().settings(this.configurationService.getFileIndexSettings()).mapping(this.configurationService.getMappingForFileType((SearchVersion)version)));
            Observable fileIndexResult = this.client.execute(builder).map(response -> new IndexCreationResult(DefaultIndexAdministrationService.statusFor(response.getStatusCode()), response.getErrorType().orElse(null)));
            return Observable.merge(repoIndexResult, projectIndexResult, indexStateIndexResult, (Observable)fileIndexResult);
        });
    }

    @Override
    public Observable<IndexDeletionResult> deleteCodeSearchIndexes() {
        Observable<IndexDeletionResult> repoIndexDelete = this.deleteIndex(RepositoryMapping.type().indexName());
        Observable<IndexDeletionResult> projectIndexDelete = this.deleteIndex(ProjectMapping.type().indexName());
        Observable<IndexDeletionResult> indexStateIndexDelete = this.deleteIndex(IndexStateMapping.type().indexName());
        Observable<IndexDeletionResult> fileIndexDelete = this.deleteIndex(FileMapping.type().indexName());
        Observable<IndexDeletionResult> oldFileIndexDelete = this.deleteIndex(FileMapping.type().indexName() + "-v1");
        return Observable.merge(repoIndexDelete, projectIndexDelete, indexStateIndexDelete, fileIndexDelete, oldFileIndexDelete);
    }

    @Override
    public Observable<IndexSettingsResult> getSettings() {
        return this.client.execute(ES.index((String)FileMapping.type().indexName()).settings()).map(response -> new IndexSettingsResult.Builder(FileMapping.type().indexName(), (IndexSettingsResponse)response).build());
    }

    @Override
    public Observable<IndexCreationResult> recreateCodeSearchIndexes() {
        Observable<IndexDeletionResult> deleteResult = this.deleteCodeSearchIndexes();
        ArrayList errors = new ArrayList();
        Observables.consume(deleteResult, e -> {
            log.error("Failed to delete index", e);
            errors.add(e.getMessage());
        }, deleted -> {
            if (deleted.getResponseStatus() != ResponseStatus.SUCCESS && !deleted.getErrorType().map(error -> error.equals("index_not_found_exception")).orElse(false).booleanValue()) {
                deleted.getErrorType().ifPresent(errors::add);
                errors.add(deleted.getErrorType().orElse("Unknown error"));
            }
        });
        if (!errors.isEmpty()) {
            log.error("Failed to delete indexes: ''{}''", errors);
            throw new IndexException("Failed to delete indexes in the search server");
        }
        return this.createCodeSearchIndexes();
    }

    @Override
    public Observable<IndexCreationResult> recreateRepositoryIndex() {
        Observable<IndexDeletionResult> repoIndexDelete = this.deleteIndex(RepositoryMapping.type().indexName());
        ArrayList errors = new ArrayList();
        Observables.consume(repoIndexDelete, e -> {
            log.error("Failed to delete index", e);
            errors.add(e.getMessage());
        }, deleted -> {
            if (deleted.getResponseStatus() != ResponseStatus.SUCCESS && !deleted.getErrorType().map(error -> error.equals("index_not_found_exception")).orElse(false).booleanValue()) {
                deleted.getErrorType().ifPresent(errors::add);
                errors.add(deleted.getErrorType().orElse("Unknown error"));
            }
        });
        if (!errors.isEmpty()) {
            log.error("Failed to delete indexes: ''{}''", errors);
            throw new IndexException("Failed to delete indexes on the search server");
        }
        return this.client.getVersion().flatMap(version -> {
            DefaultIndexAdministrationService.failIfRunningOldVersion(version);
            return this.createIndex(RepositoryMapping.type(), this.configurationService.getEntityIndexSettings(), this.configurationService.getMappingForRepositoryType((SearchVersion)version));
        });
    }

    @Override
    public <T extends MappingField> Observable<PutMappingResponse> updateMapping(UpdateMappingRequest<T> request) {
        return this.client.getVersion().flatMap(version -> {
            DefaultIndexAdministrationService.failIfRunningOldVersion(version);
            PutMappingRequestBuilder putMapping = ES.index((String)request.getIndexName()).type().putMapping().source((ContentBuilder)request.getMapping());
            return this.client.execute(putMapping);
        });
    }

    @Override
    public Observable<IndexValidationResult> validateCodeSearchMapping() {
        return this.client.getVersion().flatMap(version -> {
            DefaultIndexAdministrationService.failIfRunningOldVersion(version);
            String indexNames = String.format("%s,%s,%s,%s", FileMapping.type().indexName(), IndexStateMapping.type().indexName(), RepositoryMapping.type().indexName(), ProjectMapping.type().indexName());
            Observable validationResponse = this.client.execute(ES.index((String)indexNames).mapping());
            return validationResponse.map(response -> {
                IndexValidationResult.Builder resultBuilder = IndexValidationResult.builder();
                if (response.isStatusSuccess()) {
                    resultBuilder.responseStatus(ResponseStatus.SUCCESS);
                    this.validateMapping((IndexMappingResponse)response, resultBuilder, FileMapping.type(), this.configurationService.getMappingForFileType((SearchVersion)version));
                    this.validateMapping((IndexMappingResponse)response, resultBuilder, IndexStateMapping.type(), this.configurationService.getMappingForIndexStateType((SearchVersion)version));
                    this.validateMapping((IndexMappingResponse)response, resultBuilder, ProjectMapping.type(), this.configurationService.getMappingForProjectType((SearchVersion)version));
                    this.validateMapping((IndexMappingResponse)response, resultBuilder, RepositoryMapping.type(), this.configurationService.getMappingForRepositoryType((SearchVersion)version));
                }
                return resultBuilder.build();
            });
        });
    }

    private List<String> compareMapping(MappingType type, ObjectContent mappings, ObjectContent expectedMapping) {
        Optional<ObjectContent> foundContent = Optional.of(mappings);
        return foundContent.map(found -> {
            ObjectContent wantedProperties = (ObjectContent)expectedMapping.getObjectContent("properties").get();
            ObjectContent foundProperties = found.getObjectContent("properties").orElseGet(() -> ES.objectContent().build());
            HashSet foundNames = Sets.newHashSet((Iterable)foundProperties.names());
            HashSet wantedNames = Sets.newHashSet((Iterable)wantedProperties.names());
            Sets.SetView missingProperties = Sets.difference((Set)wantedNames, (Set)foundNames);
            Sets.SetView presentProperties = Sets.intersection((Set)wantedNames, (Set)foundNames);
            return Stream.concat(missingProperties.stream().map(prop -> "Field '" + prop + "' is missing"), presentProperties.stream().flatMap(prop -> this.compareMappingField((String)prop, (ObjectContent)wantedProperties.getObjectContent(prop).get(), (ObjectContent)foundProperties.getObjectContent(prop).get()).stream())).collect(Collectors.toList());
        }).orElseGet(() -> Collections.singletonList(MessageFormat.format("Type ''{0}'' is not present", type.typeName())));
    }

    private static ResponseStatus statusFor(int statusCode) {
        return statusCode == 200 ? ResponseStatus.SUCCESS : ResponseStatus.ERROR;
    }

    private void validateMapping(IndexMappingResponse response, IndexValidationResult.Builder resultBuilder, MappingType type, MappingBuilder mappingBuilder) {
        ObjectContent indexSettings = (ObjectContent)response.getContent().getObjectContent(type.indexName()).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Index with name {0} does not exist", type.indexName())));
        ObjectContent mappings = (ObjectContent)indexSettings.getObjectContent("mappings").orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Index with name {0} does not contain any mappings", type.indexName())));
        this.validateMappingForType(resultBuilder, mappings, type, (ObjectContent)mappingBuilder.build());
    }

    private static void failIfRunningOldVersion(SearchVersion searchVersion) {
        if (!searchVersion.isSupported()) {
            throw new IndexException(MessageFormat.format("Unsupported search version {0} {1}. Unable to continue, operator intervention is required.", searchVersion.getDistribution().getName(), searchVersion.getVersion()));
        }
    }

    private Observable<IndexCreationResult> createIndex(MappingType type, IndexSettingsBuilder indexSettings, MappingBuilder mappingBuilder) {
        CreateIndexRequestBuilder indexBuilder = ES.index((String)type.indexName()).create().source((ContentBuilder)ES.createIndexSource().settings(indexSettings).mapping(mappingBuilder));
        return this.client.execute(indexBuilder).map(response -> new IndexCreationResult(DefaultIndexAdministrationService.statusFor(response.getStatusCode()), response.getErrorType().orElse(null)));
    }

    private List<String> compareMappingField(String fieldName, ObjectContent wantedSettings, ObjectContent foundSettings) {
        return wantedSettings.names().stream().flatMap(name -> Optionals.toStream(wantedSettings.get(name)).flatMap(wantedValue -> foundSettings.get(name).map(foundValue -> {
            if (!wantedValue.equals(foundValue)) {
                return Stream.of("Field '" + fieldName + "' has unexpected value for '" + name + "'. Expected: " + String.valueOf(wantedValue) + ", actual: " + String.valueOf(foundValue));
            }
            return Stream.empty();
        }).orElse(Stream.of("Field '" + fieldName + "' has no value for '" + name + "'. Expected: " + String.valueOf(wantedValue))))).collect(Collectors.toList());
    }

    private Observable<IndexDeletionResult> deleteIndex(String name) {
        return this.client.execute(ES.index((String)name).delete()).map(deleteIndexResponse -> new IndexDeletionResult(DefaultIndexAdministrationService.statusFor(deleteIndexResponse.getStatusCode()), deleteIndexResponse.getErrorType().orElse(null)));
    }

    private void validateMappingForType(IndexValidationResult.Builder resultBuilder, ObjectContent mappings, MappingType mappingType, ObjectContent expectedMapping) {
        List<String> errors = this.compareMapping(mappingType, mappings, expectedMapping);
        if (!errors.isEmpty()) {
            resultBuilder.validationError(mappingType, errors);
        }
    }
}

