/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.administration;

import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexStateMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.ProjectMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.indexing.administration.FieldDataTypes;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexConfigurationService;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.content.Content;
import com.atlassian.elasticsearch.client.content.ContentBuilder;
import com.atlassian.elasticsearch.client.content.StringValueContent;
import com.atlassian.elasticsearch.client.indices.FieldBuilder;
import com.atlassian.elasticsearch.client.indices.IndexSettingsBuilder;
import com.atlassian.elasticsearch.client.indices.MappingBuilder;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultIndexConfigurationService
implements IndexConfigurationService {
    @VisibleForTesting
    public static final int MAX_RESULT_WINDOW = Integer.getInteger("index.codesearch.resultWindow.max", 1000);
    protected static final String ANALYZER_CODE = "analyzer_code";
    protected static final String ANALYZER_CODE_SEARCH = "analyzer_code_search";
    protected static final String ANALYZER_FILENAME = "analyzer_filename";
    protected static final String ANALYZER_KEYWORD_LOWERCASE = "analyzer_keyword_lowercase";
    protected static final String ANALYZER_PATH = "analyzer_path";
    protected static final String ANALYZER_QUICK_SEARCH = "analyzer_quick_search";
    protected static final String ANALYZER_SINGLE_CHARACTERS = "analyzer_single_characters";
    protected static final String ANALYZER_STANDARD = "standard";
    protected static final String CHAR_FILTER_STRIP_LINE_NUMBERS = "char_filter_strip_line_numbers";
    protected static final String FILTER_QUICK_SEARCH_EDGE_NGRAM = "filter_quick_search_edge_ngram";
    protected static final String TOKENIZER_DOT = "tokenizer_dot";
    protected static final String TOKENIZER_SINGLE_CHARACTERS = "tokenizer_single_characters";
    protected static final String TOKENIZER_SLASH = "tokenizer_slash";
    private static final String FILTER_EXTRACT_PARTS_DELIMITED_BY_DOTS = "filter_extract_parts_delimited_by_dots";
    private static final String FILTER_EXTRACT_SUBWORDS = "filter_extract_subwords";
    private static final String FILTER_REMOVE_EMPTY_TOKENS = "filter_remove_empty_tokens";
    private static final String FILTER_REPLACE_SINGLE_ALPHANUMERIC = "filter_replace_single_alphanumeric";
    private static final int NUM_REPLICAS = Integer.getInteger("index.codesearch.node.replicas.num", 1);
    private static final int NUM_SHARDS = Integer.getInteger("index.codesearch.node.shards.num", 5);
    protected final int maxResultWindow;
    protected final int numReplicas;
    protected final int numShards;

    public DefaultIndexConfigurationService(int numShards, int numReplicas, int maxResultWindow) {
        this.numShards = Math.max(numShards, 1);
        this.numReplicas = Math.max(numReplicas, 0);
        this.maxResultWindow = maxResultWindow;
    }

    public DefaultIndexConfigurationService() {
        this(NUM_SHARDS, NUM_REPLICAS, MAX_RESULT_WINDOW);
    }

    @Override
    @Nonnull
    public IndexSettingsBuilder getEntityIndexSettings() {
        return this.commonIndexSettings().analysis(ES.analysis().filter(FILTER_QUICK_SEARCH_EDGE_NGRAM, ES.objectContent().with("type", "edge_ngram").with("min_gram", (Number)1).with("max_gram", (Number)20)).tokenizer(TOKENIZER_SINGLE_CHARACTERS, ES.objectContent().with("type", "ngram").with("min_gram", (Number)1).with("max_gram", (Number)1)).analyzer(ANALYZER_KEYWORD_LOWERCASE, ES.objectContent().with("type", "custom").with("tokenizer", "keyword").with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)"lowercase")))).analyzer(ANALYZER_QUICK_SEARCH, ES.objectContent().with("type", "custom").with("tokenizer", ANALYZER_STANDARD).with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)"lowercase")).with((Content)StringValueContent.of((String)FILTER_QUICK_SEARCH_EDGE_NGRAM)))).analyzer(ANALYZER_SINGLE_CHARACTERS, ES.objectContent().with("type", "custom").with("tokenizer", TOKENIZER_SINGLE_CHARACTERS)));
    }

    @Override
    @Nonnull
    public IndexSettingsBuilder getFileIndexSettings() {
        return this.commonIndexSettings().analysis(ES.analysis().charFilter(CHAR_FILTER_STRIP_LINE_NUMBERS, ES.objectContent().with("type", "pattern_replace").with("pattern", "(?:^|\\n)\\d+ ").with("replacement", " ")).filter(FILTER_QUICK_SEARCH_EDGE_NGRAM, ES.objectContent().with("type", "edge_ngram").with("min_gram", (Number)1).with("max_gram", (Number)20)).filter(FILTER_REPLACE_SINGLE_ALPHANUMERIC, ES.objectContent().with("type", "pattern_replace").with("pattern", "^\\p{Alnum}$")).filter(FILTER_REMOVE_EMPTY_TOKENS, ES.objectContent().with("type", "length").with("min", "1")).filter(FILTER_EXTRACT_SUBWORDS, ES.objectContent().with("type", "word_delimiter_graph").with("preserve_original", true).with("split_on_case_change", true).with("split_on_numerics", false).with("type_table", ". => ALPHANUM")).filter(FILTER_EXTRACT_PARTS_DELIMITED_BY_DOTS, ES.objectContent().with("type", "word_delimiter_graph").with("preserve_original", true).with("split_on_case_change", false).with("split_on_numerics", false).with("type_table", "_ => ALPHANUM")).tokenizer(TOKENIZER_DOT, ES.objectContent().with("type", "pattern").with("pattern", "\\.")).tokenizer(TOKENIZER_SINGLE_CHARACTERS, ES.objectContent().with("type", "ngram").with("min_gram", (Number)1).with("max_gram", (Number)1)).tokenizer(TOKENIZER_SLASH, ES.objectContent().with("type", "pattern").with("pattern", "/")).analyzer(ANALYZER_CODE, ES.objectContent().with("type", "custom").with("char_filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)CHAR_FILTER_STRIP_LINE_NUMBERS))).with("tokenizer", ANALYZER_STANDARD).with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)FILTER_EXTRACT_SUBWORDS)).with((Content)StringValueContent.of((String)FILTER_EXTRACT_PARTS_DELIMITED_BY_DOTS)).with((Content)StringValueContent.of((String)FILTER_REPLACE_SINGLE_ALPHANUMERIC)).with((Content)StringValueContent.of((String)FILTER_REMOVE_EMPTY_TOKENS)).with((Content)StringValueContent.of((String)"lowercase")).with((Content)StringValueContent.of((String)"flatten_graph")))).analyzer(ANALYZER_CODE_SEARCH, ES.objectContent().with("type", "custom").with("tokenizer", ANALYZER_STANDARD).with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)FILTER_REPLACE_SINGLE_ALPHANUMERIC)).with((Content)StringValueContent.of((String)FILTER_REMOVE_EMPTY_TOKENS)).with((Content)StringValueContent.of((String)"lowercase")))).analyzer(ANALYZER_FILENAME, ES.objectContent().with("type", "custom").with("tokenizer", TOKENIZER_DOT).with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)FILTER_EXTRACT_SUBWORDS)).with((Content)StringValueContent.of((String)FILTER_REPLACE_SINGLE_ALPHANUMERIC)).with((Content)StringValueContent.of((String)FILTER_REMOVE_EMPTY_TOKENS)).with((Content)StringValueContent.of((String)"lowercase")))).analyzer(ANALYZER_KEYWORD_LOWERCASE, ES.objectContent().with("type", "custom").with("tokenizer", "keyword").with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)"lowercase")))).analyzer(ANALYZER_PATH, ES.objectContent().with("type", "custom").with("tokenizer", TOKENIZER_SLASH).with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)"lowercase")))).analyzer(ANALYZER_QUICK_SEARCH, ES.objectContent().with("type", "custom").with("tokenizer", ANALYZER_STANDARD).with("filter", (ContentBuilder)ES.arrayContent().with((Content)StringValueContent.of((String)"lowercase")).with((Content)StringValueContent.of((String)FILTER_QUICK_SEARCH_EDGE_NGRAM)))).analyzer(ANALYZER_SINGLE_CHARACTERS, ES.objectContent().with("type", "custom").with("tokenizer", TOKENIZER_SINGLE_CHARACTERS)));
    }

    @Override
    @Nonnull
    public IndexSettingsBuilder getStateIndexSettings() {
        return this.commonIndexSettings();
    }

    @Override
    @Nonnull
    public MappingBuilder getMappingForFileType(@Nonnull SearchVersion version) {
        FieldDataTypes dataTypes = Objects.requireNonNull(version, "version").getFieldDataTypes();
        return (MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)ES.mapping().field(FileMapping.REPOSITORY_ID.fieldName(), (FieldBuilder)ES.longField())).field(FileMapping.PROJECT_ID.fieldName(), (FieldBuilder)ES.longField())).field(FileMapping.ARCHIVED.fieldName(), (FieldBuilder)ES.booleanField())).field(FileMapping.PUBLIC.fieldName(), (FieldBuilder)ES.booleanField())).field(FileMapping.FORK.fieldName(), (FieldBuilder)ES.booleanField())).field(FileMapping.CONTENT.fieldName(), dataTypes.analyzedStringField(ANALYZER_CODE, ANALYZER_CODE_SEARCH))).field(FileMapping.SIZE.fieldName(), (FieldBuilder)ES.longField())).field(FileMapping.EXTENSION.fieldName(), dataTypes.notAnalyzedStringField())).field(FileMapping.PATH.fieldName(), dataTypes.analyzedStringField(ANALYZER_PATH))).field(FileMapping.FILENAME.fieldName(), dataTypes.analyzedStringField(ANALYZER_FILENAME));
    }

    @Override
    @Nonnull
    public MappingBuilder getMappingForIndexStateType(@Nonnull SearchVersion version) {
        FieldDataTypes dataTypes = Objects.requireNonNull(version, "version").getFieldDataTypes();
        return (MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)ES.mapping().field(IndexStateMapping.INDEXED_COMMIT_ID.fieldName(), dataTypes.simpleStringField())).field(IndexStateMapping.INDEXED_TIMESTAMP.fieldName(), (FieldBuilder)ES.longField())).field(IndexStateMapping.INDEXING_ERROR.fieldName(), (FieldBuilder)ES.textField().index(false))).field(IndexStateMapping.TO_COMMIT_ID.fieldName(), dataTypes.simpleStringField())).field(IndexStateMapping.CLAIM_TIMESTAMP.fieldName(), (FieldBuilder)ES.longField())).field(IndexStateMapping.RETRIES.fieldName(), (FieldBuilder)ES.integerField())).field(IndexStateMapping.PROJECT_ID.fieldName(), (FieldBuilder)ES.longField())).field(IndexStateMapping.ARCHIVED.fieldName(), (FieldBuilder)ES.booleanField())).field(IndexStateMapping.FORK.fieldName(), (FieldBuilder)ES.booleanField())).field(IndexStateMapping.PUBLIC.fieldName(), (FieldBuilder)ES.booleanField());
    }

    @Override
    @Nonnull
    public MappingBuilder getMappingForProjectType(@Nonnull SearchVersion version) {
        FieldDataTypes dataTypes = Objects.requireNonNull(version, "version").getFieldDataTypes();
        return (MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)ES.mapping().field(ProjectMapping.NAME.fieldName(), dataTypes.simpleStringField())).field(ProjectMapping.KEY.fieldName(), dataTypes.lowercaseKeywordTextField())).field(ProjectMapping.AVATAR_TYPE.fieldName(), dataTypes.simpleStringField())).field(ProjectMapping.AVATAR_DATA.fieldName(), dataTypes.simpleStringField())).field(ProjectMapping.PUBLIC.fieldName(), (FieldBuilder)ES.booleanField());
    }

    @Override
    @Nonnull
    public MappingBuilder getMappingForRepositoryType(@Nonnull SearchVersion version) {
        FieldDataTypes dataTypes = Objects.requireNonNull(version, "version").getFieldDataTypes();
        return (MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)((MappingBuilder)ES.mapping().field(RepositoryMapping.NAME.fieldName(), dataTypes.simpleStringField())).field(RepositoryMapping.SLUG.fieldName(), dataTypes.lowercaseKeywordTextField())).field(RepositoryMapping.QUICK_SEARCH_PROJECT_NAME.fieldName(), dataTypes.quickSearchStringFieldWithRawField())).field(RepositoryMapping.QUICK_SEARCH_REPOSITORY_NAME.fieldName(), dataTypes.quickSearchStringFieldWithRawField())).field(RepositoryMapping.QUICK_SEARCH_REPOSITORY_DESCRIPTION.fieldName(), dataTypes.quickSearchStringField())).field(RepositoryMapping.PROJECT_ID.fieldName(), (FieldBuilder)ES.longField())).field(RepositoryMapping.AVATAR_TYPE.fieldName(), dataTypes.simpleStringField())).field(RepositoryMapping.AVATAR_DATA.fieldName(), dataTypes.simpleStringField())).field(RepositoryMapping.ARCHIVED.fieldName(), (FieldBuilder)ES.booleanField())).field(RepositoryMapping.PUBLIC.fieldName(), (FieldBuilder)ES.booleanField())).field(RepositoryMapping.FORK.fieldName(), (FieldBuilder)ES.booleanField())).field(RepositoryMapping.ORIGIN_ID.fieldName(), (FieldBuilder)ES.integerField())).field(RepositoryMapping.HIERARCHY_ID.fieldName(), dataTypes.simpleStringField())).field(RepositoryMapping.RECENT_ACTIVITY.fieldName(), (FieldBuilder)ES.dateField())).field(RepositoryMapping.PROJECT_TYPE.fieldName(), (FieldBuilder)ES.integerField())).field(RepositoryMapping.SIZE.fieldName(), (FieldBuilder)ES.longField())).field(RepositoryMapping.USER_ACTIVE.fieldName(), (FieldBuilder)ES.booleanField());
    }

    @Nonnull
    private IndexSettingsBuilder commonIndexSettings() {
        return ES.indexSettings().setting("refresh_interval", "30s").setting("index.query.default_field", "content").setting("index.max_result_window", Integer.toString(this.maxResultWindow)).setting("index.codec", "best_compression").numberOfShards(this.numShards).numberOfReplicas(this.numReplicas);
    }
}

