/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.administration;

import com.atlassian.bitbucket.internal.search.indexing.administration.AbstractResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.ResponseStatus;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.internal.search.version.SearchVersionUtils;
import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.indices.IndexSettingsResponse;
import jakarta.annotation.Nonnull;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;

public class IndexSettingsResult
extends AbstractResult {
    private static final int OPENSEARCH_MIN_VERSION_ID = 0x8000000;
    private final SearchVersion createdVersion;

    private IndexSettingsResult(Builder builder) {
        super(builder.responseStatus);
        this.createdVersion = builder.createdVersion;
    }

    @Nonnull
    public Optional<SearchVersion> getCreatedVersion() {
        return Optional.ofNullable(this.createdVersion);
    }

    public static class Builder {
        private final SearchVersion createdVersion;
        private final ResponseStatus responseStatus;

        public Builder(@Nonnull String indexName, @Nonnull IndexSettingsResponse response) {
            if (Objects.requireNonNull(response, "response").isStatusSuccess()) {
                this.createdVersion = response.getContent().getObjectContent(indexName).flatMap(content -> content.getObjectContent("settings")).flatMap(content -> content.getObjectContent("index")).flatMap(content -> content.getObjectContent("version")).map(Builder::resolveCreatedVersion).orElseThrow(() -> new IllegalStateException(MessageFormat.format("Failed to parse settings response: {0}", response.getContent())));
                this.responseStatus = ResponseStatus.SUCCESS;
            } else {
                this.createdVersion = null;
                this.responseStatus = ResponseStatus.ERROR;
            }
        }

        @Nonnull
        public IndexSettingsResult build() {
            return new IndexSettingsResult(this);
        }

        private static SearchVersion resolveCreatedVersion(ObjectContent content) {
            Long versionId = content.getString("created").map(Long::valueOf).orElse(null);
            String versionString = content.getString("created_string").orElse(null);
            if (versionId == null || versionString == null) {
                return null;
            }
            String distributionString = versionId < 0x8000000L ? null : "opensearch";
            return SearchVersionUtils.getVersionFactory(distributionString, versionString).create();
        }
    }
}

