/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.administration;

import com.atlassian.bitbucket.internal.search.common.mapping.MappingType;
import com.atlassian.bitbucket.internal.search.indexing.administration.AbstractResult;
import com.atlassian.bitbucket.internal.search.indexing.administration.ResponseStatus;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IndexValidationResult
extends AbstractResult {
    private final Map<MappingType, List<String>> validationErrors;

    private IndexValidationResult(Builder builder) {
        super(builder.responseStatus);
        this.validationErrors = builder.validationErrorsBuilder.build();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public Map<MappingType, List<String>> getValidationErrors() {
        return Collections.unmodifiableMap(this.validationErrors);
    }

    public static class Builder {
        private ResponseStatus responseStatus = ResponseStatus.ERROR;
        private final ImmutableMap.Builder<MappingType, List<String>> validationErrorsBuilder = ImmutableMap.builder();

        public IndexValidationResult build() {
            return new IndexValidationResult(this);
        }

        @Nonnull
        public Builder responseStatus(@Nonnull ResponseStatus value) {
            this.responseStatus = Objects.requireNonNull(value, "responseStatus");
            return this;
        }

        @Nonnull
        public Builder validationError(@Nonnull MappingType type, @Nonnull List<String> errors) {
            this.validationErrorsBuilder.put((Object)Objects.requireNonNull(type, "type"), Objects.requireNonNull(errors, "errors"));
            return this;
        }
    }
}

