/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.administration;

import com.atlassian.bitbucket.internal.search.indexing.administration.FieldDataTypes;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.indices.FieldBuilder;
import com.atlassian.elasticsearch.client.indices.TextFieldBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class OpenSearchFieldDataTypes
implements FieldDataTypes {
    @Override
    @Nonnull
    public FieldBuilder analyzedStringField(@Nonnull String analyzer, @Nonnull String searchAnalyzer) {
        return ES.textField().analyzer(Objects.requireNonNull(analyzer, "analyzer")).searchAnalyzer(Objects.requireNonNull(searchAnalyzer, "searchAnalyzer"));
    }

    @Override
    @Nonnull
    public FieldBuilder analyzedStringField(@Nonnull String analyzer) {
        return ES.textField().analyzer(Objects.requireNonNull(analyzer, "analyzer"));
    }

    @Override
    @Nonnull
    public FieldBuilder lowercaseKeywordTextField() {
        return ES.textField().analyzer("analyzer_keyword_lowercase").indexOptions(TextFieldBuilder.IndexOptions.DOCS).norms(false);
    }

    @Override
    @Nonnull
    public FieldBuilder notAnalyzedStringField() {
        return ES.keywordField();
    }

    @Nonnull
    public TextFieldBuilder quickSearchStringField() {
        return (TextFieldBuilder)ES.textField().analyzer("analyzer_quick_search").searchAnalyzer("standard").field("length", (FieldBuilder)ES.tokenCountField().analyzer("analyzer_single_characters"));
    }

    @Override
    @Nonnull
    public FieldBuilder quickSearchStringFieldWithRawField() {
        return this.quickSearchStringField().field("raw", this.notAnalyzedStringField());
    }

    @Override
    @Nonnull
    public FieldBuilder simpleStringField() {
        return ES.textField();
    }
}

