/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.administration;

import com.atlassian.bitbucket.internal.search.common.mapping.MappingField;
import com.atlassian.bitbucket.internal.search.common.mapping.MappingType;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.indices.FieldBuilder;
import com.atlassian.elasticsearch.client.indices.MappingBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class UpdateMappingRequest<T extends MappingField> {
    private final MappingBuilder mappingBuilder;
    private final MappingType mappingType;

    private UpdateMappingRequest(Builder<T> builder) {
        this.mappingType = builder.mappingType;
        this.mappingBuilder = builder.mappingBuilder;
    }

    @Nonnull
    public String getIndexName() {
        return this.mappingType.indexName();
    }

    @Nonnull
    public MappingBuilder getMapping() {
        return this.mappingBuilder;
    }

    public static class Builder<S extends MappingField> {
        private final MappingBuilder mappingBuilder = ES.mapping();
        private final MappingType mappingType;

        public Builder(@Nonnull MappingType mappingType) {
            this.mappingType = Objects.requireNonNull(mappingType, "mappingType");
        }

        @Nonnull
        public UpdateMappingRequest<S> build() {
            return new UpdateMappingRequest(this);
        }

        @Nonnull
        public Builder<S> withField(@Nonnull MappingField field, @Nonnull FieldBuilder fieldSpec) {
            Objects.requireNonNull(field, "field");
            Objects.requireNonNull(fieldSpec, "fieldSpec");
            this.mappingBuilder.field(field.fieldName(), fieldSpec);
            return this;
        }
    }
}

