/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.analytics;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.analytics.IndexingPropertiesEvent;
import com.atlassian.bitbucket.internal.search.indexing.analytics.SearchVersionEvent;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexingAnalyticsJob
implements JobRunner {
    private static final JobId JOB_ID = JobId.of((String)IndexingAnalyticsJob.class.getSimpleName());
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)IndexingAnalyticsJob.class.getName());
    private final SearchClient client;
    private final EventPublisher eventPublisher;
    private final IndexingProperties indexingSettings;

    @Autowired
    public IndexingAnalyticsJob(EventPublisher eventPublisher, SchedulerService schedulerService, SearchClient client, IndexingProperties indexingSettings) throws SchedulerServiceException {
        this.eventPublisher = eventPublisher;
        this.client = client;
        this.indexingSettings = indexingSettings;
        this.scheduleSelf(schedulerService, Clock.systemUTC());
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        this.eventPublisher.publish((Object)new IndexingPropertiesEvent(this, this.indexingSettings.getCodeIndexingEnabled(), this.indexingSettings.getCodeIndexingExcludes()));
        try {
            this.client.getVersion().toBlocking().subscribe(searchVersion -> this.eventPublisher.publish((Object)new SearchVersionEvent(this, (SearchVersion)searchVersion)));
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    private void scheduleSelf(SchedulerService schedulerService, Clock clock) throws SchedulerServiceException {
        schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
        long interval = TimeUnit.DAYS.toMillis(7L);
        long firstRun = TimeUnit.MINUTES.toMillis(5L);
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(clock.millis() + firstRun))));
    }
}

