/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.search.SearchDistribution;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.search.version")
public class SearchVersionEvent
extends ApplicationEvent {
    private final int bugfix;
    private final SearchDistribution distribution;
    private final int major;
    private final int minor;

    public SearchVersionEvent(@Nonnull Object source, @Nonnull SearchVersion searchVersion) {
        super(source);
        Objects.requireNonNull(searchVersion, "searchVersion");
        this.bugfix = searchVersion.getVersion().getPatch();
        this.distribution = Objects.requireNonNull(searchVersion.getDistribution(), "distribution");
        this.major = searchVersion.getVersion().getMajor();
        this.minor = searchVersion.getVersion().getMinor();
    }

    public int getBugfixVersion() {
        return this.bugfix;
    }

    @Nonnull
    public SearchDistribution getDistribution() {
        return this.distribution;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }
}

