/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.client;

import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.internal.search.client.ConfigurableSearchClient;
import com.atlassian.bitbucket.internal.search.common.clientutil.SearchClientFactory;
import com.atlassian.bitbucket.internal.search.common.clientutil.SearchClientSettings;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobManager;
import com.atlassian.bitbucket.internal.search.common.settings.PluginProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationChangedMessage;
import com.atlassian.bitbucket.internal.search.common.settings.SearchSettingsAccessor;
import com.atlassian.bitbucket.internal.search.common.settings.UsernamePassword;
import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.jobs.SearchSynchronizeJob;
import com.atlassian.bitbucket.internal.search.indexing.jobs.StartupChecksJob;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.codahale.metrics.MetricRegistry;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="indexingClientLifecycleManager")
public class IndexingClientLifecycleManager
implements LifecycleAware,
SearchClientSettings,
TopicListener<SearchConfigurationChangedMessage> {
    private static final int MAX_POOL_CONNECTIONS = 20;
    private static final Logger log = LoggerFactory.getLogger(IndexingClientLifecycleManager.class);
    private final ClusterJobManager clusterJobManager;
    private final ConfigurableSearchClient configurableSearchClient;
    private final IndexingProperties indexingProperties;
    private final MetricRegistry metricRegistry;
    private final SearchSettingsAccessor searchSettingsAccessor;
    private final TopicService topicService;
    private final SearchClientFactory searchClientFactory;
    private final EscalatedSecurityContext withSysAdmin;
    private String subscriptionId;

    @Autowired
    public IndexingClientLifecycleManager(ConfigurableSearchClient configurableSearchClient, SearchClientFactory searchClientFactory, ClusterJobManager clusterJobManager, IndexingProperties indexingProperties, MetricRegistry metricRegistry, SearchSettingsAccessor searchSettingsAccessor, SecurityService securityService, TopicService topicService) {
        this.configurableSearchClient = configurableSearchClient;
        this.searchClientFactory = searchClientFactory;
        this.clusterJobManager = clusterJobManager;
        this.indexingProperties = indexingProperties;
        this.metricRegistry = metricRegistry;
        this.searchSettingsAccessor = searchSettingsAccessor;
        this.topicService = topicService;
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "Create search client");
    }

    @Override
    public Optional<String> getAwsRegion() {
        return this.searchSettingsAccessor.getAwsRegion();
    }

    @Override
    public String getBaseUrl() {
        return this.searchSettingsAccessor.getBaseUrl();
    }

    @Override
    public Duration getHttpConnectionPoolTimeout() {
        return this.indexingProperties.getHttpConnectionPoolTimeout();
    }

    @Override
    public Duration getHttpConnectionTimeout() {
        return this.indexingProperties.getHttpConnectionTimeout();
    }

    @Override
    public Duration getHttpKeepAliveIdleTimeout() {
        return this.indexingProperties.getHttpKeepAliveIdleTimeout();
    }

    @Override
    public Duration getHttpSocketTimeout() {
        return this.indexingProperties.getHttpSocketTimeout();
    }

    @Override
    public int getMaxPoolConnections() {
        return 20;
    }

    @Override
    public Optional<UsernamePassword> getUsernamePassword() {
        return this.searchSettingsAccessor.getUsernamePassword();
    }

    @EventListener
    public void onClusterNodeAddedEvent(ClusterNodeAddedEvent event) {
        this.refreshClientInternal();
    }

    public void onMessage(@Nonnull MessageEvent<SearchConfigurationChangedMessage> message) {
        log.debug("Received search server configuration changed event");
        this.refreshClientInternal();
        if (((SearchConfigurationChangedMessage)message.getMessage()).hasChanged(PluginProperty.BASE_URL)) {
            this.runSynchronization();
        }
    }

    public void onStart() {
        this.subscriptionId = this.topicService.getTopic("search:config.changed", TopicSettings.builder(SearchConfigurationChangedMessage.class).build()).subscribe((TopicListener)this);
        this.refreshClientInternal();
    }

    public void onStop() {
        if (this.subscriptionId != null) {
            this.topicService.getTopic("search:config.changed", TopicSettings.builder(SearchConfigurationChangedMessage.class).build()).unsubscribe(this.subscriptionId);
        }
        this.configurableSearchClient.close();
    }

    public void refreshClient() {
        this.configurableSearchClient.replaceClient(this.searchClientFactory.create(this, this.metricRegistry));
    }

    private void refreshClientInternal() {
        this.withSysAdmin.call(() -> {
            this.refreshClient();
            return null;
        });
    }

    private void runSynchronization() {
        this.clusterJobManager.unscheduleAdHocJob(StartupChecksJob.class);
        this.clusterJobManager.unscheduleAdHocJob(SearchSynchronizeJob.class);
        this.clusterJobManager.scheduleAdHocJob(Instant.now(), SearchSynchronizeJob.class);
    }
}

