/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.configuration;

import com.atlassian.bitbucket.internal.search.client.DefaultConfigurableSearchClient;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.administration.DefaultIndexAdministrationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexAdministrationService;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexingSettings;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="indexingConfiguration")
public class IndexingPluginConfiguration {
    public static final String EVENT_Q_EXECUTOR_BEAN = "searchIndexingExecutorBean";
    public static final String EVENT_Q_THREAD_NAME = "search-indexing";

    @Bean
    public DefaultConfigurableSearchClient searchClient() {
        return new DefaultConfigurableSearchClient();
    }

    @Bean(name={"searchIndexingExecutorBean"})
    public ExecutorService eventQueueExecutor() {
        return Executors.newFixedThreadPool(1, ThreadFactories.namedThreadFactory((String)EVENT_Q_THREAD_NAME));
    }

    @Bean
    public IndexAdministrationService indexAdministrationService(SearchClient client) {
        return new DefaultIndexAdministrationService(client);
    }

    @Bean
    public IndexingSettings indexingSettings(IndexingProperties indexingProperties) {
        return indexingProperties.getIndexingSettings();
    }
}

