/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.content;

import com.atlassian.bitbucket.internal.search.indexing.content.ChangeType;
import com.atlassian.bitbucket.internal.search.indexing.content.File;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public abstract class AbstractFile
implements File {
    protected final ChangeType changeType;
    protected final String path;
    protected final long size;

    protected AbstractFile(Builder builder) {
        this.path = Objects.requireNonNull(builder.path, "path");
        this.changeType = Objects.requireNonNull(builder.changeType, "changeType");
        this.size = builder.size;
    }

    @Override
    @Nonnull
    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    protected static abstract class Builder<B extends Builder, T extends AbstractFile> {
        private ChangeType changeType;
        private String path;
        private long size;

        protected Builder() {
        }

        public abstract T build();

        public B changeType(@Nonnull ChangeType value) {
            this.changeType = Objects.requireNonNull(value, "changeType");
            return this.self();
        }

        public B path(@Nonnull String value) {
            this.path = Objects.requireNonNull(value, "path");
            return this.self();
        }

        public B size(long value) {
            this.size = value;
            return this.self();
        }

        protected B self() {
            return (B)this;
        }
    }
}

