/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.content;

import com.atlassian.bitbucket.internal.search.indexing.content.ChangeType;
import com.atlassian.bitbucket.internal.search.indexing.content.ContentServiceException;
import com.atlassian.bitbucket.internal.search.indexing.content.File;
import com.atlassian.bitbucket.internal.search.indexing.content.SimpleBinaryFile;
import com.atlassian.bitbucket.internal.search.indexing.content.SimpleFile;
import com.atlassian.bitbucket.internal.search.indexing.content.SimpleTextFile;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.bulk.BulkChangeType;
import com.atlassian.bitbucket.scm.bulk.BulkContentCallback;
import com.atlassian.bitbucket.scm.bulk.BulkContentDisposition;
import com.atlassian.bitbucket.scm.bulk.BulkContentSummary;
import com.atlassian.bitbucket.scm.bulk.BulkFile;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import rx.Observer;

public class ObserverBulkContentCallback
implements BulkContentCallback {
    private static final int BUF_SIZE_BINARY_DETECTION = 4096;
    private static final int BUF_SIZE_ENCODING_DETECTION = 32768;
    private static final int BUF_SIZE = Integer.max(4096, 32768);
    private final int maxTextFileSize;
    private final Observer<? super File> observer;

    public ObserverBulkContentCallback(Observer<? super File> observer, int maxTextFileSize) {
        this.observer = observer;
        this.maxTextFileSize = maxTextFileSize;
    }

    @Nonnull
    public BulkContentDisposition accept(@Nonnull BulkFile file) {
        if (file.getChangeType() == BulkChangeType.DELETE || file.getSize() > (long)this.maxTextFileSize) {
            SimpleFile result = ((SimpleFile.Builder)((SimpleFile.Builder)((SimpleFile.Builder)SimpleFile.builder().path(file.getPath())).changeType(ObserverBulkContentCallback.getChangeType(file.getChangeType()))).size(file.getSize())).build();
            this.observer.onNext((Object)result);
            return BulkContentDisposition.SKIP;
        }
        return BulkContentDisposition.STREAM;
    }

    public void onEnd(@Nonnull BulkContentSummary summary) {
        if (summary.getResult() == CommandResult.SUCCEEDED) {
            this.observer.onCompleted();
        } else {
            this.observer.onError((Throwable)new ContentServiceException("An unknown error occurred while retrieving content from Git"));
        }
    }

    public void onFile(@Nonnull BulkFile file, @Nonnull InputStream content) {
        byte[] contentBytes;
        boolean binary;
        String path = file.getPath();
        int size = (int)file.getSize();
        ChangeType changeType = ObserverBulkContentCallback.getChangeType(file.getChangeType());
        if (!content.markSupported()) {
            content = new BufferedInputStream(content, BUF_SIZE);
        }
        try {
            binary = ContentDetectionUtils.isBinary((InputStream)content, (int)4096);
        }
        catch (IOException e) {
            this.observer.onError((Throwable)new ContentServiceException("Error during binary detection for file: " + path, e));
            return;
        }
        Charset charset = null;
        if (!binary) {
            try {
                String encoding = ContentDetectionUtils.detectEncoding((InputStream)content, (int)32768);
                charset = encoding != null ? Charset.forName(encoding) : StandardCharsets.UTF_8;
            }
            catch (UnsupportedCharsetException e) {
                binary = true;
            }
            catch (IOException e) {
                this.observer.onError((Throwable)new ContentServiceException("Error during encoding detection for file: " + path, e));
                return;
            }
        }
        try {
            ByteArrayOutputStream fullContent = new ByteArrayOutputStream(size);
            ByteStreams.copy((InputStream)content, (OutputStream)fullContent);
            contentBytes = fullContent.toByteArray();
        }
        catch (IOException e) {
            this.observer.onError((Throwable)new ContentServiceException("Error during stream copy for file: " + path, e));
            return;
        }
        if (binary) {
            SimpleBinaryFile binaryFile = ((SimpleBinaryFile.Builder)((SimpleBinaryFile.Builder)((SimpleBinaryFile.Builder)SimpleBinaryFile.builder().contentStream(new ByteArrayInputStream(contentBytes)).size(size)).path(file.getPath())).changeType(changeType)).build();
            this.observer.onNext((Object)binaryFile);
        } else {
            SimpleTextFile textFile = ((SimpleTextFile.Builder)((SimpleTextFile.Builder)((SimpleTextFile.Builder)SimpleTextFile.builder().charSource(ByteSource.wrap((byte[])contentBytes).asCharSource(charset)).size(size)).path(file.getPath())).changeType(changeType)).build();
            this.observer.onNext((Object)textFile);
        }
    }

    private static ChangeType getChangeType(BulkChangeType status) {
        switch (status) {
            case ADD: {
                return ChangeType.ADD;
            }
            case MODIFY: {
                return ChangeType.MODIFY;
            }
            case DELETE: {
                return ChangeType.DELETE;
            }
        }
        throw new IllegalStateException("Unknown file change: " + String.valueOf(status));
    }
}

