/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.content;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.content.CommitNotFoundException;
import com.atlassian.bitbucket.internal.search.indexing.content.ContentRequest;
import com.atlassian.bitbucket.internal.search.indexing.content.ContentResult;
import com.atlassian.bitbucket.internal.search.indexing.content.ContentService;
import com.atlassian.bitbucket.internal.search.indexing.content.File;
import com.atlassian.bitbucket.internal.search.indexing.content.ObserverBulkContentCallback;
import com.atlassian.bitbucket.internal.search.indexing.content.RepositoryHandle;
import com.atlassian.bitbucket.internal.search.indexing.content.SimpleContentResult;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.NotFoundException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.UnavailableScmException;
import com.atlassian.bitbucket.scm.UnsupportedScmException;
import com.atlassian.bitbucket.scm.bulk.BulkContentCallback;
import com.atlassian.bitbucket.scm.bulk.BulkContentCommandParameters;
import com.atlassian.bitbucket.scm.bulk.ScmBulkContentCommandFactory;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.primitives.Ints;
import io.atlassian.fugue.Either;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;

@Service
public class ServerContentService
implements ContentService {
    private static final Logger log = LoggerFactory.getLogger(ServerContentService.class);
    private final int maxTextFileSize;
    private final Duration processExecutionTimeout;
    private final Duration processIdleTimeout;
    private final RefService refService;
    private final RepositorySupplier repositorySupplier;
    private final ScmService scmService;
    private final SecurityService securityService;

    @Autowired
    public ServerContentService(IndexingProperties properties, RefService refService, RepositorySupplier repositorySupplier, ScmService scmService, SecurityService securityService) {
        this.refService = refService;
        this.repositorySupplier = repositorySupplier;
        this.scmService = scmService;
        this.securityService = securityService;
        this.maxTextFileSize = properties.getIndexingMaxTextFileSize();
        this.processExecutionTimeout = properties.getIndexingProcessExecutionTimeout();
        this.processIdleTimeout = properties.getIndexingProcessIdleTimeout();
    }

    @Override
    public Either<Exception, Optional<String>> getDefaultBranchCommitId(RepositoryHandle repositoryHandle) {
        return (Either)this.securityService.withPermission(Permission.REPO_READ, "Indexing repository for search").call(() -> this.doGetDefaultBranchCommitId(repositoryHandle));
    }

    @Override
    public ContentResult streamFilesFromRepository(ContentRequest contentRequest) {
        return (ContentResult)this.securityService.withPermission(Permission.REPO_READ, "Indexing repository for search").call(() -> this.doStreamFilesFromRepository(contentRequest));
    }

    @Override
    public boolean supportsStreamingFiles(RepositoryHandle repositoryHandle) {
        try {
            int repositoryId = ServerContentService.getRepositoryId(repositoryHandle);
            Repository repository = (Repository)this.securityService.withPermission(Permission.REPO_READ, "Indexing checking repository for supported features").call(() -> this.repositorySupplier.getById(repositoryId));
            return repository != null && this.scmService.isSupported(repository, ScmFeature.BULK_CONTENT);
        }
        catch (UnavailableScmException | UnsupportedScmException e) {
            log.debug("The Scm Plugin for streaming content from repository {} is not available or does support content streaming", e);
            return false;
        }
    }

    private static ContentResult errorResult(Throwable throwable) {
        return SimpleContentResult.builder().files((Observable<File>)Observable.error((Throwable)throwable)).build();
    }

    private static int getRepositoryId(RepositoryHandle repositoryHandle) {
        return Ints.checkedCast((long)repositoryHandle.getId());
    }

    private Either<Exception, Optional<String>> doGetDefaultBranchCommitId(RepositoryHandle repositoryHandle) {
        int repositoryId = ServerContentService.getRepositoryId(repositoryHandle);
        Repository repository = this.repositorySupplier.getById(repositoryId);
        if (repository == null) {
            return Either.left((Object)new NotFoundException(MessageFormat.format("Repository with id {0} was not found", repositoryId)));
        }
        try {
            String commitId = this.getTheLatestCommitOnDefaultBranch(repository);
            return Either.right(Optional.of(commitId));
        }
        catch (NoDefaultBranchException e) {
            return Either.right(Optional.empty());
        }
    }

    private ContentResult doStreamFilesFromRepository(ContentRequest contentRequest) {
        int repositoryId = ServerContentService.getRepositoryId(contentRequest.getRepositoryHandle());
        try {
            Repository repository = this.repositorySupplier.getById(repositoryId);
            if (repository == null) {
                return ServerContentService.errorResult(new NotFoundException(MessageFormat.format("Repository with id {0} could not be found", repositoryId)));
            }
            String commitId = contentRequest.getCommitId();
            Optional<String> previousCommitId = contentRequest.getPreviousCommitId();
            BulkContentCommandParameters.Builder parametersBuilder = new BulkContentCommandParameters.Builder(commitId);
            previousCommitId.ifPresent(arg_0 -> ((BulkContentCommandParameters.Builder)parametersBuilder).sinceCommitId(arg_0));
            Observable files = Observable.create(subscriber -> this.streamContent(repository, parametersBuilder.build(), (Subscriber<? super File>)subscriber));
            return SimpleContentResult.builder().files((Observable<File>)files).build();
        }
        catch (NoDefaultBranchException e) {
            log.info("The repository with id {} does not have a default branch specified. Cannot be indexed.", (Object)repositoryId);
            return SimpleContentResult.builder().files((Observable<File>)Observable.empty()).build();
        }
        catch (UnsupportedScmException e) {
            log.info("The repository with id {} has an unsupported SCM type. Cannot be indexed.", (Object)repositoryId);
            return SimpleContentResult.builder().files((Observable<File>)Observable.empty()).build();
        }
    }

    private String getTheLatestCommitOnDefaultBranch(Repository repository) {
        Branch branch = this.refService.getDefaultBranch(repository);
        return branch.getLatestCommit();
    }

    private void streamContent(Repository repository, BulkContentCommandParameters parameters, Subscriber<? super File> subscriber) {
        try {
            ScmBulkContentCommandFactory bulkContentCommandFactory = this.scmService.getBulkContentCommandFactory(repository);
            ObserverBulkContentCallback callback = new ObserverBulkContentCallback((Observer<? super File>)subscriber, this.maxTextFileSize);
            Command command = bulkContentCommandFactory.contents(parameters, (BulkContentCallback)callback);
            command.setExecutionTimeout(this.processExecutionTimeout.getSeconds());
            command.setIdleTimeout(this.processIdleTimeout.getSeconds());
            command.call();
        }
        catch (FeatureUnsupportedScmException e) {
            subscriber.onError((Throwable)new UnsupportedOperationException(MessageFormat.format("The repository with id {0} and slug {1} is unable to satisfy the request to stream file content", repository.getId(), repository.getSlug())));
        }
        catch (NoSuchCommitException e) {
            subscriber.onError((Throwable)new CommitNotFoundException(MessageFormat.format("The commit id {0} could not be found in repository {1}.", e.getCommitId(), repository), (Throwable)e, repository.getId(), e.getCommitId()));
        }
    }
}

