/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.content;

import com.atlassian.bitbucket.internal.search.indexing.content.AbstractFile;
import com.atlassian.bitbucket.internal.search.indexing.content.BinaryFile;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

public class SimpleBinaryFile
extends AbstractFile
implements BinaryFile {
    private final InputStream contentStream;

    private SimpleBinaryFile(Builder builder) {
        super(builder);
        this.contentStream = builder.contentStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Optional<InputStream> getContentStream() {
        return Optional.ofNullable(this.contentStream);
    }

    public static class Builder
    extends AbstractFile.Builder<Builder, SimpleBinaryFile> {
        private InputStream contentStream;

        @Override
        public SimpleBinaryFile build() {
            return new SimpleBinaryFile(this);
        }

        public Builder contentStream(@Nonnull InputStream value) {
            this.contentStream = Objects.requireNonNull(value, "contentStream");
            return this;
        }
    }
}

