/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.content;

import com.atlassian.bitbucket.internal.search.indexing.content.ContentRequest;
import com.atlassian.bitbucket.internal.search.indexing.content.RepositoryHandle;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class SimpleContentRequest
implements ContentRequest {
    private final String commitId;
    private final String previousCommitId;
    private final RepositoryHandle repositoryHandle;

    private SimpleContentRequest(Builder builder) {
        this.repositoryHandle = Objects.requireNonNull(builder.repositoryHandle, "builder.repositoryHandle");
        this.commitId = Objects.requireNonNull(builder.commitId, "builder.commitId");
        this.previousCommitId = builder.previousCommitId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Override
    @Nonnull
    public Optional<String> getPreviousCommitId() {
        return Optional.ofNullable(this.previousCommitId);
    }

    @Override
    @Nonnull
    public RepositoryHandle getRepositoryHandle() {
        return this.repositoryHandle;
    }

    public String toString() {
        return "SimpleContentRequest{repositoryHandle=" + String.valueOf(this.repositoryHandle) + ", commitId=" + this.commitId + ", previousCommitId=" + this.previousCommitId + "}";
    }

    public static final class Builder {
        private String commitId;
        private String previousCommitId;
        private RepositoryHandle repositoryHandle;

        private Builder() {
        }

        @Nonnull
        public SimpleContentRequest build() {
            return new SimpleContentRequest(this);
        }

        @Nonnull
        public Builder commitId(@Nonnull String commitId) {
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            return this;
        }

        @Nonnull
        public Builder previousCommitId(@Nonnull String previousCommitId) {
            this.previousCommitId = Objects.requireNonNull(previousCommitId, "previousCommitId");
            return this;
        }

        @Nonnull
        public Builder repositoryHandle(@Nonnull RepositoryHandle repositoryHandle) {
            this.repositoryHandle = Objects.requireNonNull(repositoryHandle, "repositoryHandle");
            return this;
        }
    }
}

