/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.content;

import com.atlassian.bitbucket.internal.search.indexing.content.RepositoryHandle;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.util.Optional;

public class SimpleRepositoryHandle
implements RepositoryHandle {
    private final int id;
    private final Path path;

    private SimpleRepositoryHandle(Builder builder) {
        this.id = builder.id;
        this.path = builder.path;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Optional<Path> getPath() {
        return Optional.ofNullable(this.path);
    }

    public static class Builder {
        private int id;
        private Path path;

        @Nonnull
        public SimpleRepositoryHandle build() {
            return new SimpleRepositoryHandle(this);
        }

        @Nonnull
        public Builder id(int value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nullable Path value) {
            this.path = value;
            return this;
        }
    }
}

