/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.content;

import com.atlassian.bitbucket.internal.search.indexing.content.AbstractFile;
import com.atlassian.bitbucket.internal.search.indexing.content.TextFile;
import com.google.common.io.CharSource;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class SimpleTextFile
extends AbstractFile
implements TextFile {
    private final CharSource charSource;

    private SimpleTextFile(Builder builder) {
        super(builder);
        this.charSource = builder.charSource;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Optional<CharSource> getContent() {
        return Optional.ofNullable(this.charSource);
    }

    public static class Builder
    extends AbstractFile.Builder<Builder, SimpleTextFile> {
        private CharSource charSource;

        @Override
        public SimpleTextFile build() {
            return new SimpleTextFile(this);
        }

        public Builder charSource(@Nonnull CharSource charSource) {
            this.charSource = Objects.requireNonNull(charSource, "charSource");
            return this;
        }
    }
}

