/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public abstract class AbstractRepositoryIndexEvent
implements IndexEvent {
    private final int repositoryId;
    private final Date timestamp;

    protected AbstractRepositoryIndexEvent(Builder builder) {
        this.repositoryId = builder.repositoryId;
        this.timestamp = builder.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRepositoryIndexEvent that = (AbstractRepositoryIndexEvent)o;
        return this.repositoryId == that.repositoryId;
    }

    @Override
    @Nonnull
    public EventType getEventType() {
        return EventType.REPOSITORY;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    @Nullable
    public Date getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.repositoryId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{repositoryId=" + this.repositoryId + "}";
    }

    public static abstract class Builder<B extends Builder<B, E>, E extends AbstractRepositoryIndexEvent> {
        protected int repositoryId;
        protected Date timestamp;

        @Nonnull
        public abstract E build();

        @Nonnull
        public B repositoryId(int value) {
            this.repositoryId = value;
            return this.self();
        }

        @Nonnull
        public B timestamp(@Nullable Date timestamp) {
            this.timestamp = timestamp;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

