/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.locks.ReentrantLock;

class DedupingDelayQueue<E extends Delayed> {
    private final ReentrantLock lock;
    private final int maxSize;
    private final DelayQueue<E> queue;

    public DedupingDelayQueue() {
        this(Integer.MAX_VALUE);
    }

    public DedupingDelayQueue(int maxSize) {
        this.maxSize = maxSize;
        this.lock = new ReentrantLock(true);
        this.queue = new DelayQueue();
    }

    public void clear() {
        this.queue.clear();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean offer(@Nonnull E delayed) {
        Objects.requireNonNull(delayed, "delayed");
        if (this.size() >= this.maxSize) {
            return false;
        }
        this.lock.lock();
        try {
            this.queue.remove(delayed);
            boolean bl = this.queue.add(delayed);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Optional<E> peek() {
        return Optional.ofNullable(this.queue.peek());
    }

    public Optional<E> poll() {
        return Optional.ofNullable(this.queue.poll());
    }

    public int size() {
        return this.queue.size();
    }

    public E take() throws InterruptedException {
        return (E)this.queue.take();
    }

    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }
}

