/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import com.atlassian.bitbucket.internal.search.indexing.event.DedupingDelayQueue;
import com.atlassian.bitbucket.internal.search.indexing.event.DelayedScheduler;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DedupingDelayedScheduler<T>
implements DelayedScheduler<T> {
    private static final Logger log = LoggerFactory.getLogger(DedupingDelayedScheduler.class);
    private final Clock clock;
    private final DedupingDelayQueue<DelayedPayload<T>> dedupingDelayQueue;
    private final AtomicBoolean isRunning;
    private final ExecutorService transferService;
    private Consumer<T> processor;
    private Future<?> transferFuture;

    public DedupingDelayedScheduler() {
        this(Clock.systemUTC(), new DedupingDelayQueue<DelayedPayload<T>>(10000));
    }

    @VisibleForTesting
    DedupingDelayedScheduler(Clock clock, DedupingDelayQueue<DelayedPayload<T>> dedupingDelayQueue) {
        this.clock = clock;
        this.dedupingDelayQueue = dedupingDelayQueue;
        this.isRunning = new AtomicBoolean(false);
        this.transferService = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)"delayed-scheduler"));
    }

    @Override
    public int getNumberOfScheduledItems() {
        return this.dedupingDelayQueue.size();
    }

    @Override
    public void schedule(T payload, Duration delay) {
        DelayedPayload<T> event = new DelayedPayload<T>(payload, delay, this.clock);
        boolean added = this.dedupingDelayQueue.offer(event);
        if (!added) {
            log.warn("Dropping delayed event {} because maximum queue size was reached", event);
        }
    }

    @Override
    public void setProcessor(Consumer<T> processor) {
        this.processor = processor;
    }

    @PreDestroy
    void shutdown() {
        this.isRunning.set(false);
        if (this.transferFuture != null) {
            this.transferFuture.cancel(true);
        }
        ExecutorUtils.shutdown((ExecutorService)this.transferService, (Logger)log);
        DelayedPayload[] events = new DelayedPayload[this.dedupingDelayQueue.size()];
        this.dedupingDelayQueue.toArray(events);
        for (DelayedPayload event : events) {
            log.debug("Dropping delayed event {} because executor is shutting down", (Object)event);
        }
        this.dedupingDelayQueue.clear();
    }

    @PostConstruct
    void startTransferWorker() {
        this.isRunning.set(true);
        this.transferFuture = this.transferService.submit(() -> {
            while (!Thread.currentThread().isInterrupted() && this.isRunning.get()) {
                try {
                    DelayedPayload<T> delayedPayload = this.dedupingDelayQueue.take();
                    if (this.processor == null) continue;
                    this.processor.accept(delayedPayload.getPayload());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    static class DelayedPayload<E>
    implements Delayed {
        private final Clock clock;
        private final Duration delay;
        private final E payload;
        private final Instant startTime;

        public DelayedPayload(E payload, Duration delay, Clock clock) {
            this.payload = payload;
            this.delay = delay;
            this.clock = clock;
            this.startTime = clock.instant().plus(delay);
        }

        @Override
        public int compareTo(@Nonnull Delayed o) {
            return this.startTime.compareTo(((DelayedPayload)o).startTime);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DelayedPayload other = (DelayedPayload)obj;
            return Objects.equals(this.payload, other.payload);
        }

        @Override
        public long getDelay(@Nonnull TimeUnit unit) {
            return TimeUnit.NANOSECONDS.convert(Duration.between(this.clock.instant(), this.startTime).toNanos(), unit);
        }

        public E getPayload() {
            return this.payload;
        }

        public int hashCode() {
            return Objects.hash(this.payload);
        }

        public String toString() {
            return "DelayedPayload{clock.instant=" + String.valueOf(this.clock.instant()) + ", delay=" + String.valueOf(this.delay) + ", payload=" + String.valueOf(this.payload) + ", startTime=" + String.valueOf(this.startTime) + "}";
        }
    }
}

