/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import com.atlassian.bitbucket.dmz.search.IndexingWorkerThreadManager;
import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.event.DelayedScheduler;
import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventVisitor;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventWorker;
import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.IndexingQueueManager;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexFilterService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadLifecycleListener;
import com.atlassian.bitbucket.util.RetryBackoffUtils;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="defaultIndexEventQueueProcessor")
public class DefaultIndexEventQueueProcessor
implements IndexEventQueueProcessor,
IndexingWorkerThreadManager,
LifecycleAware {
    private static final int MAX_RETRIES = 5;
    private static final Duration MAX_RETRY_DELAY = Duration.ofMinutes(30L);
    private static final Duration MIN_RETRY_DELAY = Duration.ofMinutes(1L);
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexEventQueueProcessor.class);
    private final DelayedScheduler<QueuedEvent> delayedScheduler;
    private final Duration dequeueTimeout;
    private final Duration enqueueTimeout;
    private final IndexEventWorker eventWorker;
    private final ExecutorService executorService;
    private final IndexFilterService indexFilterService;
    private final IndexingQueueManager indexingQueueManager;
    private final IndexingThreadLifecycleListener lifecycleListener;
    private final Duration shutdownTimeout;
    private Future<Boolean> eventLoopFuture;
    private volatile boolean shouldProcessEvents;

    @Autowired
    public DefaultIndexEventQueueProcessor(@Qualifier(value="searchIndexingExecutorBean") ExecutorService executorService, IndexEventWorker eventWorker, IndexFilterService indexFilterService, IndexingProperties indexingProperties, DelayedScheduler<QueuedEvent> delayedScheduler, IndexingQueueManager indexingQueueManager, IndexingThreadLifecycleListener lifecycleListener) {
        this(executorService, eventWorker, indexingQueueManager, delayedScheduler, indexFilterService, indexingProperties.getIndexingEventEnqueueTimeout(), indexingProperties.getIndexingEventDequeueTimeout(), indexingProperties.getIndexingEventShutdownTimeout(), lifecycleListener);
    }

    @VisibleForTesting
    DefaultIndexEventQueueProcessor(ExecutorService executorService, IndexEventWorker eventWorker, IndexingQueueManager indexingQueueManager, DelayedScheduler<QueuedEvent> delayedScheduler, IndexFilterService indexFilterService, Duration enqueueTimeout, Duration dequeueTimeout, Duration shutdownTimeout, IndexingThreadLifecycleListener lifecycleListener) {
        this.executorService = executorService;
        this.eventWorker = eventWorker;
        this.delayedScheduler = delayedScheduler;
        this.indexFilterService = indexFilterService;
        this.indexingQueueManager = indexingQueueManager;
        this.enqueueTimeout = enqueueTimeout;
        this.dequeueTimeout = dequeueTimeout;
        this.shutdownTimeout = shutdownTimeout;
        this.lifecycleListener = lifecycleListener;
        delayedScheduler.setProcessor(this::retryDelayedEvent);
    }

    @Override
    public void clear() {
        this.indexingQueueManager.clear();
    }

    @Override
    public int getDelayQueueSize() {
        return this.delayedScheduler.getNumberOfScheduledItems();
    }

    @Override
    public int getEventQueueSize() {
        return this.indexingQueueManager.size();
    }

    @Override
    public boolean isWorkerAlive() {
        return this.eventLoopFuture != null && !this.eventLoopFuture.isCancelled() && !this.eventLoopFuture.isDone();
    }

    public void onStart() {
        this.resumeIndexing();
    }

    public void onStop() {
        this.suspendIndexing(false);
        try {
            this.executorService.awaitTermination(this.shutdownTimeout.getSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("search-indexing executor did not exit in a graceful manner.", (Throwable)e);
        }
        finally {
            this.executorService.shutdown();
        }
        log.info("Worker thread has been shut down");
    }

    @Override
    public boolean queueEvent(@Nonnull IndexEvent indexEvent) {
        return this.queueEvent(indexEvent, this.enqueueTimeout);
    }

    @Override
    public boolean queueEvent(@Nonnull IndexEvent indexEvent, @Nonnull Duration timeout) {
        QueuedEvent queuedEvent = new QueuedEvent(Objects.requireNonNull(indexEvent, "indexEvent"), 0);
        return this.addEvent(queuedEvent, timeout);
    }

    public void resumeIndexing() {
        log.debug("Event processor is now entering RUNNING state");
        if (this.isWorkerAlive()) {
            log.error("Worker thread has already been started...");
            return;
        }
        this.shouldProcessEvents = true;
        this.eventLoopFuture = this.executorService.submit(() -> {
            this.lifecycleListener.onIndexingThreadStarted(this.eventLoopFuture);
            return this.processEvents();
        });
        log.info("Event queue processor has been started");
    }

    public void suspendIndexing(boolean mayInterruptIfRunning) {
        log.debug("Event processor is now entering STOPPED state");
        this.shouldProcessEvents = false;
        try {
            this.indexingQueueManager.offer(new QueuedEvent(WakeUpEvent.INSTANCE, 0), this.shutdownTimeout);
        }
        catch (InterruptedException e) {
            log.warn("Unable to enqueue a WakeUpEvent to allow the worker thread to exit cleanly. Cancelling thread.", (Throwable)e);
        }
        try {
            if (this.eventLoopFuture != null && !this.eventLoopFuture.isCancelled()) {
                if (mayInterruptIfRunning) {
                    if (this.eventLoopFuture.cancel(true)) {
                        log.debug("Indexing thread could not be cancelled, usually because it has already completed");
                    } else {
                        log.debug("Indexing thread was successfully cancelled");
                    }
                } else {
                    this.eventLoopFuture.get(this.shutdownTimeout.getSeconds(), TimeUnit.SECONDS);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Worker has been interrupted and will now exit.", (Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            log.warn("Worker did not exit in a graceful manner.", (Throwable)e);
        }
    }

    @VisibleForTesting
    Future<Boolean> getEventLoopFuture() {
        return this.eventLoopFuture;
    }

    private boolean addEvent(QueuedEvent queuedEvent, @Nonnull Duration timeout) {
        try {
            if (this.indexingQueueManager.offer(queuedEvent, timeout)) {
                return true;
            }
            log.debug("Unable to enqueue event [{}], the queue is possibly full.", (Object)queuedEvent.getEvent());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Thread was interrupted while waiting to enqueue an event.", (Throwable)e);
        }
        return false;
    }

    private void delayedRetry(QueuedEvent queuedEvent, int retries) {
        this.lifecycleListener.onProcessingUpdate("Retrying event %s".formatted(queuedEvent));
        Duration delay = RetryBackoffUtils.calculateDelay((int)retries, (Duration)MIN_RETRY_DELAY, (Duration)MAX_RETRY_DELAY);
        log.debug("Worker instructed us to retry {}, retrying in {} s", (Object)queuedEvent, (Object)delay.getSeconds());
        QueuedEvent retryEvent = new QueuedEvent(queuedEvent.getEvent(), retries);
        this.delayedScheduler.schedule(retryEvent, delay);
    }

    private void delayedRetryOrDropEvent(QueuedEvent queuedEvent) {
        int retries = queuedEvent.getRetries() + 1;
        if (retries > 5) {
            this.lifecycleListener.onProcessingUpdate("Maximum retries %d reached for %s".formatted(5, queuedEvent));
            log.info("Worker instructed us to retry {} but the maximum number of retries ({}) has been reached, dropping event", (Object)queuedEvent, (Object)5);
            return;
        }
        this.delayedRetry(queuedEvent, retries);
    }

    private void processEvent(QueuedEvent queuedEvent) {
        IndexEvent indexEvent = queuedEvent.getEvent();
        if (this.indexFilterService.shouldProcess(indexEvent)) {
            this.lifecycleListener.onProcessingStarted(queuedEvent);
            try {
                this.eventWorker.process(indexEvent).subscribe(instruction -> {
                    if (instruction instanceof IndexEventWorker.UnlimitedRetryInstruction) {
                        this.delayedRetry(queuedEvent, queuedEvent.getRetries());
                    } else if (instruction instanceof IndexEventWorker.LimitedRetryInstruction) {
                        this.delayedRetryOrDropEvent(queuedEvent);
                    } else if (instruction instanceof IndexEventWorker.QueueEventInstruction) {
                        IndexEventWorker.QueueEventInstruction queueEventResult = (IndexEventWorker.QueueEventInstruction)instruction;
                        IndexEvent newEvent = queueEventResult.getEvent();
                        log.info("Worker instructed us to enqueue {} after processing {}", (Object)newEvent, (Object)queuedEvent);
                        this.queueEvent(newEvent);
                    }
                }, exception -> {
                    this.lifecycleListener.onProcessingUpdate("Unexpected error from index event worker. See logs for details");
                    log.error("Unexpected error from index event worker for {}, dropping event", (Object)queuedEvent, exception);
                });
            }
            finally {
                this.lifecycleListener.onProcessingFinished();
            }
        } else {
            log.debug("Event was excluded from indexing based on indexing filter rules: [{}]", (Object)indexEvent);
        }
    }

    private boolean processEvents() {
        try {
            while (this.shouldProcessEvents && !Thread.currentThread().isInterrupted()) {
                this.indexingQueueManager.poll(this.dequeueTimeout).ifPresent(event -> {
                    if (event.getEvent() != WakeUpEvent.INSTANCE) {
                        try {
                            this.processEvent((QueuedEvent)event);
                        }
                        catch (Exception e) {
                            log.error("An unexpected error was encountered while processing event [{}]\nThis event is now discarded and will not be retried.\nResuming normal processing of events.", event, (Object)e);
                        }
                    }
                });
            }
            return true;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void retryDelayedEvent(QueuedEvent queuedEvent) {
        this.addEvent(queuedEvent, this.enqueueTimeout);
    }

    private static class WakeUpEvent
    implements IndexEvent {
        public static final WakeUpEvent INSTANCE = new WakeUpEvent();

        private WakeUpEvent() {
        }

        @Override
        public <T> T accept(IndexEventVisitor<T> visitor) {
            return null;
        }

        @Override
        @Nonnull
        public EventType getEventType() {
            return EventType.OTHER;
        }
    }
}

