/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import com.atlassian.bitbucket.dmz.repositorymanagement.DmzRepositoryManagementService;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryContextDefinition;
import com.atlassian.bitbucket.internal.search.common.mapping.SimpleRepositoryContextDefinition;
import com.atlassian.bitbucket.internal.search.indexing.content.CommitNotFoundException;
import com.atlassian.bitbucket.internal.search.indexing.event.AbstractProjectIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.AbstractRepositoryIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventVisitor;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventWorker;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ReindexRepositoryFilesEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentIndirectlyModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryPropertiesModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.AlreadyClaimedException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.NotFoundException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.ServiceUnavailableException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.UnrecoverableIndexException;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexFilesRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexFilesResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexService;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexStrategy;
import com.atlassian.bitbucket.internal.search.indexing.indexer.ProjectPropertiesIndexRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RemoveResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RepositoryPropertiesIndexRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.UpdateResult;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadLifecycleListener;
import com.atlassian.bitbucket.internal.search.search.IndexedRepository;
import com.atlassian.bitbucket.internal.search.search.UnsuccessfulResponseException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.RepositorySize;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PagedIterable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.ConnectException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;
import rx.Observer;

@Component
public class DefaultIndexEventWorker
implements IndexEventWorker,
IndexEventVisitor<Observable<IndexEventWorker.Instruction>> {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexEventWorker.class);
    private final IndexService indexService;
    private final IndexingThreadLifecycleListener lifecycleListener;
    private final PermissionService permissionService;
    private final ProjectService projectService;
    private final DmzRepositoryManagementService repositoryManagementService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final UserService userService;

    @Autowired
    public DefaultIndexEventWorker(IndexService indexService, IndexingThreadLifecycleListener lifecycleListener, PermissionService permissionService, ProjectService projectService, DmzRepositoryManagementService repositoryManagementService, RepositoryService repositoryService, SecurityService securityService, UserService userService) {
        this.lifecycleListener = lifecycleListener;
        this.indexService = indexService;
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.repositoryManagementService = repositoryManagementService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.userService = userService;
    }

    @Override
    public Observable<IndexEventWorker.Instruction> process(IndexEvent event) {
        this.lifecycleListener.onProcessingUpdate("Starting process for event: %s".formatted(event));
        return event.accept(this);
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(ReindexRepositoryFilesEvent event) {
        return this.createInstruction(event, (IndexedRepository indexedRepository) -> this.retryOnError(this.removeFiles(event.getRepositoryId()).flatMap(removeResult -> this.indexFiles(indexedRepository.getRepository()))));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(RepositoryContentIndirectlyModifiedIndexEvent event) {
        return this.updateContentForRepository(event);
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(UserDeletedIndexEvent event) {
        ApplicationUser user = this.userService.getUserByName(event.getUsername(), true);
        return this.getRepositoriesForUser(user).map(repository -> new IndexEventWorker.QueueEventInstruction(((RepositoryModifiedIndexEvent.Builder)RepositoryModifiedIndexEvent.builder().repositoryId(repository.getId())).build()));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(UserCreatedIndexEvent event) {
        return this.getRepositoriesForUser(this.userService.getUserByName(event.getUser().getName(), true)).map(repository -> new IndexEventWorker.QueueEventInstruction(((RepositoryModifiedIndexEvent.Builder)RepositoryModifiedIndexEvent.builder().repositoryId(repository.getId())).build()));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(RepositoryPropertiesModifiedIndexEvent event) {
        return this.createInstruction(event, (IndexedRepository repository) -> this.retryOnError(this.indexRepositoryProperties((IndexedRepository)repository)));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(ProjectCreatedIndexEvent event) {
        return this.createInstruction(event, (Project project) -> this.retryOnError(this.indexProjectProperties((Project)project)));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(ProjectDeletedIndexEvent event) {
        return this.retryOnError(this.removeProjectProperties(event.getProjectId()));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(ProjectModifiedIndexEvent event) {
        return this.createInstruction(event, (Project project) -> this.retryOnError(this.indexProjectProperties((Project)project)));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(RepositoryCreatedIndexEvent event) {
        return this.createInstruction(event, (IndexedRepository indexedRepository) -> this.indexRepositoryProperties((IndexedRepository)indexedRepository).flatMap(result -> this.indexProjectProperties(indexedRepository.getRepository().getProject())).flatMap(result -> {
            if (indexedRepository.getRepository().isFork() || event.isRepositoryImported()) {
                return Observable.just((Object)new IndexEventWorker.QueueEventInstruction(((RepositoryContentIndirectlyModifiedIndexEvent.Builder)RepositoryContentIndirectlyModifiedIndexEvent.builder().repositoryId(event.getRepositoryId())).build()));
            }
            return Observable.empty();
        }));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(RepositoryDeletedIndexEvent event) {
        return this.retryOnError(this.removeRepositoryProperties(event.getRepositoryId()).flatMap(result -> this.removeFiles(event.getRepositoryId())));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(RepositoryModifiedIndexEvent event) {
        return this.createInstruction(event, (IndexedRepository indexedRepository) -> this.retryOnError(this.indexRepositoryProperties((IndexedRepository)indexedRepository).flatMap(result -> this.updateFiles(indexedRepository.getRepository()))));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(RepositoryContentModifiedIndexEvent event) {
        return this.createInstruction(event, (IndexedRepository indexedRepository) -> this.indexRepositoryProperties((IndexedRepository)indexedRepository).flatMap(result -> this.updateContentForRepository(event)));
    }

    @Override
    public Observable<IndexEventWorker.Instruction> visit(RepositoryContentDeletedIndexEvent event) {
        return this.retryOnError(this.removeFiles(event.getRepositoryId()));
    }

    @Nonnull
    private static <K, V> Observable<V> ofNullable(@Nonnull K identifier, @Nullable V value, @Nonnull Consumer<K> whenEmptyConsumer) {
        if (value == null) {
            Objects.requireNonNull(whenEmptyConsumer, "whenEmptyConsumer").accept(Objects.requireNonNull(identifier, "identifier"));
            return Observable.empty();
        }
        return Observable.just(value);
    }

    private Observable<IndexEventWorker.Instruction> createInstruction(AbstractProjectIndexEvent event, Function<Project, Observable<IndexEventWorker.Instruction>> instructionFromProject) {
        return this.getProject(event.getProjectId()).flatMap(instructionFromProject::apply);
    }

    private Observable<IndexEventWorker.Instruction> createInstruction(AbstractRepositoryIndexEvent event, Function<IndexedRepository, Observable<IndexEventWorker.Instruction>> instructionFromRepository) {
        return this.getRepository(event).flatMap(instructionFromRepository::apply).onErrorResumeNext(error -> this.mapError((Throwable)error, event));
    }

    private Observable<Project> getProject(int projectId) {
        Project project = (Project)this.securityService.withPermission(Permission.PROJECT_READ, "Indexing of project").call(() -> this.projectService.getById(projectId));
        return DefaultIndexEventWorker.ofNullable(projectId, project, this::projectNotFound);
    }

    private Observable<IndexedRepository> getRepository(AbstractRepositoryIndexEvent event) {
        IndexedRepository indexedRepository = (IndexedRepository)this.securityService.withPermission(Permission.REPO_READ, "Indexing of repository").call(() -> this.toIndexedRepository(event));
        return DefaultIndexEventWorker.ofNullable(event.getRepositoryId(), indexedRepository, this::repositoryNotFound);
    }

    private Observable<Repository> getRepositoriesForUser(final ApplicationUser user) {
        if (user == null) {
            return Observable.empty();
        }
        PageProvider<Repository> pageProvider = new PageProvider<Repository>(){

            @Nonnull
            public Page<Repository> get(@Nonnull PageRequest pageRequest) {
                return (Page)DefaultIndexEventWorker.this.securityService.withPermission(Permission.ADMIN, "Index repositories of personal project").call(() -> DefaultIndexEventWorker.this.repositoryService.findByOwner(user, pageRequest));
            }
        };
        return Observable.from((Iterable)new PagedIterable((PageProvider)pageProvider, 100));
    }

    private Observable<IndexFilesResult> indexFiles(Repository repository) {
        IndexFilesRequest request = IndexFilesRequest.builder().indexStrategy(IndexStrategy.AUTO_DETECT).repositoryContext(this.transformToContextDefinition(repository)).build();
        return this.indexService.indexFiles(request).doOnEach((Observer)LogObserver.forRepository(repository, this.lifecycleListener));
    }

    private Observable<IndexResult> indexProjectProperties(Project project) {
        ProjectPropertiesIndexRequest request = ProjectPropertiesIndexRequest.builder().project(project).build();
        return this.indexService.indexProjectProperties(request).doOnEach((Observer)LogObserver.forProject(project, this.lifecycleListener));
    }

    private Observable<IndexResult> indexRepositoryProperties(IndexedRepository indexedRepository) {
        RepositoryPropertiesIndexRequest request = RepositoryPropertiesIndexRequest.builder().repository(indexedRepository.getRepository()).recentActivity(indexedRepository.getMostRecentActivity()).size(indexedRepository.getSize()).build();
        return this.indexService.indexRepositoryProperties(request).doOnEach((Observer)LogObserver.forRepository(indexedRepository.getRepository(), this.lifecycleListener));
    }

    private Observable<IndexEventWorker.Instruction> mapError(Throwable error) {
        return this.mapError(error, null);
    }

    private Observable<IndexEventWorker.Instruction> mapError(Throwable error, AbstractRepositoryIndexEvent event) {
        if (error instanceof UnrecoverableIndexException) {
            return Observable.empty();
        }
        if (error instanceof ServiceUnavailableException) {
            return Observable.just((Object)new IndexEventWorker.UnlimitedRetryInstruction());
        }
        if (error instanceof CommitNotFoundException) {
            CommitNotFoundException commitNotFoundException = (CommitNotFoundException)error;
            log.warn("The repository with id {}, has to be completely re-indexed to repair a data inconsistency: Could not find commit {}", (Object)commitNotFoundException.getRepositoryId(), (Object)commitNotFoundException.getCommitId());
            return Observable.just((Object)new IndexEventWorker.QueueEventInstruction(((ReindexRepositoryFilesEvent.Builder)((ReindexRepositoryFilesEvent.Builder)ReindexRepositoryFilesEvent.builder().repositoryId(commitNotFoundException.getRepositoryId())).timestamp(event == null ? null : event.getTimestamp())).build()));
        }
        return Observable.just((Object)new IndexEventWorker.LimitedRetryInstruction());
    }

    private void projectNotFound(int projectId) {
        log.error("Project with id {} is no longer available", (Object)projectId);
    }

    private Observable<RemoveResult> removeFiles(int repositoryId) {
        return this.indexService.removeFiles(repositoryId).onErrorResumeNext(error -> {
            if (error instanceof NotFoundException) {
                return Observable.just((Object)RemoveResult.builder().build());
            }
            return Observable.error((Throwable)error);
        }).doOnEach((Observer)LogObserver.forRepository(repositoryId, this.lifecycleListener));
    }

    private Observable<Boolean> removeProjectProperties(int projectId) {
        return this.indexService.removeProjectProperties(projectId).doOnEach((Observer)LogObserver.forProject(projectId, this.lifecycleListener));
    }

    private Observable<Boolean> removeRepositoryProperties(int repositoryId) {
        return this.indexService.removeRepositoryProperties(repositoryId).doOnEach((Observer)LogObserver.forRepository(repositoryId, this.lifecycleListener));
    }

    private void repositoryNotFound(int repositoryId) {
        log.error("Repository with id {} is no longer available", (Object)repositoryId);
    }

    private Observable<IndexEventWorker.Instruction> retryOnError(Observable<?> observable) {
        return observable.flatMap(result -> Observable.empty(), this::mapError, Observable::empty);
    }

    private IndexedRepository toIndexedRepository(AbstractRepositoryIndexEvent event) {
        Repository repository = this.repositoryService.getById(event.getRepositoryId());
        if (repository == null) {
            return null;
        }
        RepositorySize size = this.repositoryManagementService.getSize(repository);
        return new IndexedRepository(event.getTimestamp(), repository, size == null ? null : Long.valueOf(size.getTotal()));
    }

    private RepositoryContextDefinition transformToContextDefinition(Repository repository) {
        return SimpleRepositoryContextDefinition.builder().repositoryId(repository.getId()).projectId(repository.getProject().getId()).isArchived(repository.isArchived()).isPublic(this.permissionService.isPubliclyAccessible(repository)).isFork(repository.isFork()).build();
    }

    private Observable<IndexEventWorker.Instruction> updateContentForRepository(AbstractRepositoryIndexEvent event) {
        return this.createInstruction(event, (IndexedRepository repository) -> this.indexFiles(repository.getRepository()).flatMap(result -> {
            if (result.isMoreIndexingRequired()) {
                RepositoryContentModifiedIndexEvent newEvent = ((RepositoryContentModifiedIndexEvent.Builder)((RepositoryContentModifiedIndexEvent.Builder)RepositoryContentModifiedIndexEvent.builder().repositoryId(event.getRepositoryId())).timestamp(event.getTimestamp())).build();
                return Observable.just((Object)new IndexEventWorker.QueueEventInstruction(newEvent));
            }
            return Observable.empty();
        }, error -> this.mapError((Throwable)error, event), Observable::empty));
    }

    private Observable<UpdateResult> updateFiles(Repository repository) {
        return this.indexService.updateFiles(this.transformToContextDefinition(repository)).onErrorResumeNext(error -> {
            if (error instanceof NotFoundException) {
                return Observable.just((Object)UpdateResult.builder().build());
            }
            return Observable.error((Throwable)error);
        }).doOnEach((Observer)LogObserver.forRepository(repository, this.lifecycleListener));
    }

    private static class LogObserver
    implements Observer<Object> {
        private final String description;
        private final IndexingThreadLifecycleListener lifecycleListener;

        private LogObserver(String description, IndexingThreadLifecycleListener lifecycleListener) {
            this.description = description;
            this.lifecycleListener = lifecycleListener;
        }

        public void onCompleted() {
            this.lifecycleListener.onProcessingUpdate("Indexing - Completed indexing for %s".formatted(this.description));
            log.debug("Indexing - Completed indexing for {}", (Object)this.description);
        }

        public void onError(Throwable e) {
            if (e instanceof AlreadyClaimedException) {
                this.logEvent(Level.DEBUG, "Indexing - Not attempted for {} because it was already claimed", this.description);
            } else if (e.getCause() instanceof ConnectException) {
                this.logEvent(Level.DEBUG, "Indexing - Failed for {} because of a connection error: {}", this.description, e.getMessage());
            } else if (e instanceof ServiceUnavailableException || e instanceof UnsuccessfulResponseException) {
                this.logEvent(Level.ERROR, "Indexing - Failed for {} with error: {}", this.description, e.getMessage());
            } else {
                this.logEvent(Level.ERROR, "Indexing - Failed for {} with error: {}", this.description, e.getMessage(), e);
            }
        }

        public void onNext(Object next) {
            this.logEvent(Level.DEBUG, "Indexing - Results for {} is: {}", this.description, next);
        }

        static LogObserver forProject(int projectId, IndexingThreadLifecycleListener lifecycleListener) {
            return new LogObserver(LogObserver.formatId("Project", projectId), lifecycleListener);
        }

        static LogObserver forProject(Project project, IndexingThreadLifecycleListener lifecycleListener) {
            return new LogObserver(LogObserver.formatProject(project), lifecycleListener);
        }

        static LogObserver forRepository(int repositoryId, IndexingThreadLifecycleListener lifecycleListener) {
            return new LogObserver(LogObserver.formatId("Repository", repositoryId), lifecycleListener);
        }

        static LogObserver forRepository(Repository repository, IndexingThreadLifecycleListener lifecycleListener) {
            return new LogObserver(LogObserver.formatRepository(repository), lifecycleListener);
        }

        private static String formatId(String entityType, long id) {
            return String.format("%s with id: %s)", entityType, id);
        }

        private static String formatProject(Project project) {
            if (project == null) {
                return "project *unknown*";
            }
            return String.format("project %s (id: %s)", project.getKey(), project.getId());
        }

        private static String formatRepository(Repository repository) {
            if (repository == null) {
                return "repository *unknown*";
            }
            return String.format("repository %s/%s (id: %s)", repository.getProject().getKey(), repository.getSlug(), repository.getId());
        }

        private void logEvent(Level level, String message, Object ... args) {
            String lifeCycleMessage = message.replace("{}", "%s");
            this.lifecycleListener.onProcessingUpdate(lifeCycleMessage.formatted(args));
            log.atLevel(level).log(message, args);
        }
    }
}

