/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import com.atlassian.bitbucket.dmz.repository.DmzRepositorySizesCalculatedEvent;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.project.ProjectCreatedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryImportedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.AbstractRepositoryIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentIndirectlyModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryPropertiesModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserDeletedIndexEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.sync.RefsSynchronizedEvent;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import jakarta.annotation.Nonnull;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventHandler {
    private static final int PAGE_SIZE = 50;
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    private final IndexEventQueueProcessor processor;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    @Autowired
    public EventHandler(IndexEventQueueProcessor indexEventQueueProcessor, RefService refService, SecurityService securityService, RepositoryService repositoryService) {
        this.processor = indexEventQueueProcessor;
        this.refService = refService;
        this.securityService = securityService;
        this.repositoryService = repositoryService;
    }

    @EventListener
    public void onProjectCreated(ProjectCreatedEvent event) {
        this.enqueue(((ProjectCreatedIndexEvent.Builder)ProjectCreatedIndexEvent.builder().projectId(event.getProject().getId())).build());
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.enqueue(((ProjectDeletedIndexEvent.Builder)ProjectDeletedIndexEvent.builder().projectId(event.getProject().getId())).build());
    }

    @EventListener
    public void onProjectModified(ProjectModifiedEvent event) {
        Project newProject = event.getProject();
        this.enqueue(((ProjectModifiedIndexEvent.Builder)ProjectModifiedIndexEvent.builder().projectId(newProject.getId())).build());
        this.getRepositoriesForProject(newProject).forEach(repository -> this.enqueue(((RepositoryModifiedIndexEvent.Builder)RepositoryModifiedIndexEvent.builder().repositoryId(repository.getId())).build()));
    }

    @EventListener
    public void onRepositoryCreated(RepositoryCreatedEvent event) {
        this.enqueue(((RepositoryCreatedIndexEvent.Builder)((RepositoryCreatedIndexEvent.Builder)RepositoryCreatedIndexEvent.builder().repositoryId(event.getRepository().getId())).timestamp(event.getDate())).build());
    }

    @EventListener
    public void onRepositoryDefaultBranchModified(RepositoryDefaultBranchModifiedEvent event) {
        this.enqueue(((RepositoryContentModifiedIndexEvent.Builder)((RepositoryContentModifiedIndexEvent.Builder)RepositoryContentModifiedIndexEvent.builder().repositoryId(event.getRepository().getId())).timestamp(event.getDate())).build());
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.enqueue(((RepositoryDeletedIndexEvent.Builder)((RepositoryDeletedIndexEvent.Builder)RepositoryDeletedIndexEvent.builder().repositoryId(event.getRepository().getId())).timestamp(event.getDate())).build());
        event.getForkIds().forEach(forkId -> this.enqueue(((RepositoryModifiedIndexEvent.Builder)((RepositoryModifiedIndexEvent.Builder)RepositoryModifiedIndexEvent.builder().repositoryId((int)forkId)).timestamp(event.getDate())).build()));
    }

    @EventListener
    public void onRepositoryImported(RepositoryImportedEvent event) {
        this.enqueue(((RepositoryCreatedIndexEvent.Builder)((RepositoryCreatedIndexEvent.Builder)RepositoryCreatedIndexEvent.builder().repositoryId(event.getRepository().getId())).timestamp(event.getDate())).isRepositoryImported(true).build());
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) {
        this.enqueue(((RepositoryModifiedIndexEvent.Builder)((RepositoryModifiedIndexEvent.Builder)RepositoryModifiedIndexEvent.builder().repositoryId(event.getRepository().getId())).timestamp(event.getDate())).build());
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        Date eventTimestamp;
        Repository repository = event.getRepository();
        Branch defaultBranch = this.getDefaultBranch(repository);
        Date date = eventTimestamp = event instanceof ApplicationEvent ? ((ApplicationEvent)event).getDate() : new Date();
        if (defaultBranch != null && event.getRefChanges().stream().filter(refChange -> StandardRefType.BRANCH == refChange.getRef().getType()).anyMatch(refChange -> defaultBranch.getId().equals(refChange.getRef().getId()))) {
            AbstractRepositoryIndexEvent.Builder builder = event instanceof RefsSynchronizedEvent ? RepositoryContentIndirectlyModifiedIndexEvent.builder() : RepositoryContentModifiedIndexEvent.builder();
            this.enqueue((IndexEvent)((AbstractRepositoryIndexEvent.Builder)((AbstractRepositoryIndexEvent.Builder)builder.repositoryId(repository.getId())).timestamp(eventTimestamp)).build());
        } else {
            this.enqueue(((RepositoryPropertiesModifiedIndexEvent.Builder)((RepositoryPropertiesModifiedIndexEvent.Builder)RepositoryPropertiesModifiedIndexEvent.builder().repositoryId(event.getRepository().getId())).timestamp(eventTimestamp)).build());
        }
    }

    @EventListener
    public void onRepositorySizesCalculatedEvent(DmzRepositorySizesCalculatedEvent event) {
        event.getRepositorySizes().keySet().forEach(repoId -> this.enqueue(((RepositoryPropertiesModifiedIndexEvent.Builder)RepositoryPropertiesModifiedIndexEvent.builder().repositoryId((int)repoId)).build()));
    }

    @EventListener
    public void onUserCreatedEvent(UserCreatedEvent event) {
        this.enqueue(UserCreatedIndexEvent.builder().user((User)event.getUser()).build());
    }

    @EventListener
    public void onUserDeletedEvent(UserDeletedEvent event) {
        this.enqueue(UserDeletedIndexEvent.builder().username(event.getUsername()).build());
    }

    private void enqueue(IndexEvent indexEvent) {
        if (!this.processor.queueEvent(indexEvent)) {
            log.error("Unable to enqueue event for processing: [{}] Event is discarded and will not be retried.", (Object)indexEvent);
        }
    }

    private Branch getDefaultBranch(Repository repository) {
        try {
            return this.refService.getDefaultBranch(repository);
        }
        catch (NoDefaultBranchException e) {
            log.info("{}: {}", (Object)repository, (Object)e.getMessage());
            return null;
        }
    }

    private Iterable<Repository> getRepositoriesForProject(final Project project) {
        PageProvider<Repository> pageProvider = new PageProvider<Repository>(){

            @Nonnull
            public Page<Repository> get(@Nonnull PageRequest pageRequest) {
                return (Page)EventHandler.this.securityService.withPermission(Permission.PROJECT_READ, (Object)project, "Index repositories of project").call(() -> EventHandler.this.repositoryService.findByProjectKey(project.getKey(), pageRequest));
            }
        };
        return new PagedIterable((PageProvider)pageProvider, 50);
    }
}

