/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

public class QueuedEvent {
    private final IndexEvent event;
    private final String id;
    private final int retries;
    private final Instant timestamp;

    public QueuedEvent(@Nonnull IndexEvent event, int retries) {
        this.event = Objects.requireNonNull(event, "event");
        this.retries = retries;
        this.id = UUID.randomUUID().toString();
        this.timestamp = Instant.now();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueuedEvent that = (QueuedEvent)o;
        return Objects.equals(this.event, that.event);
    }

    @Nonnull
    public IndexEvent getEvent() {
        return this.event;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public int getRetries() {
        return this.retries;
    }

    @Nonnull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.event);
    }

    public String toString() {
        return "QueuedEvent{event=" + String.valueOf(this.event) + ", retries=" + this.retries + "}";
    }
}

