/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event;

import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventVisitor;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class UserDeletedIndexEvent
implements IndexEvent {
    private final String username;

    private UserDeletedIndexEvent(Builder builder) {
        this.username = Objects.requireNonNull(builder.username, "username");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> T accept(IndexEventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public EventType getEventType() {
        return EventType.USER;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public static class Builder {
        private String username;

        @Nonnull
        public UserDeletedIndexEvent build() {
            return new UserDeletedIndexEvent(this);
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }
    }
}

