/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event.queue;

import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.IndexingQueueManager;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.SimpleTrackedEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.TrackedEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.TrackedEventKeyResolver;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.UncheckedInterruptedException;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="defaultIndexingQueueManager")
public class DefaultIndexingQueueManager
implements IndexingQueueManager {
    private final BlockingQueue<QueuedEvent> queue;
    private final TrackedEventKeyResolver trackedEventKeyResolver;
    private final ConcurrentMap<String, TrackedEventCounter> trackedEvents;

    @Autowired
    public DefaultIndexingQueueManager(IndexingProperties indexingProperties) {
        this(indexingProperties.getIndexingEventQueueSize());
    }

    public DefaultIndexingQueueManager(int capacity) {
        this(new LinkedBlockingQueue<QueuedEvent>(capacity), new TrackedEventKeyResolver(), new ConcurrentHashMap<String, TrackedEventCounter>());
    }

    @VisibleForTesting
    DefaultIndexingQueueManager(BlockingQueue<QueuedEvent> queue, TrackedEventKeyResolver trackedEventKeyResolver, ConcurrentMap<String, TrackedEventCounter> trackedEvents) {
        this.queue = queue;
        this.trackedEventKeyResolver = trackedEventKeyResolver;
        this.trackedEvents = trackedEvents;
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.trackedEvents.clear();
    }

    @Override
    @Nonnull
    public Optional<TrackedEvent> getTrackedEvent(@Nonnull EventType type, @Nonnull Object key) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(key, "key");
        String trackedEventKey = this.trackedEventKeyResolver.getFullyQualifiedKey(type, key);
        TrackedEventCounter trackedEventCounter = (TrackedEventCounter)this.trackedEvents.get(trackedEventKey);
        if (trackedEventCounter == null) {
            return Optional.empty();
        }
        return Optional.of(trackedEventCounter.latestEvent());
    }

    @Override
    public boolean offer(@Nonnull QueuedEvent queuedEvent, @Nonnull Duration timeout) throws InterruptedException {
        Objects.requireNonNull(queuedEvent, "queuedEvent");
        if (!queuedEvent.getEvent().getEventType().isTrackedInQueue()) {
            return this.doOffer(queuedEvent, timeout);
        }
        MutableBoolean offered = new MutableBoolean(true);
        String trackedEventKey = this.getTrackedEventKey(queuedEvent.getEvent());
        this.trackedEvents.compute(trackedEventKey, (key, previousCounter) -> {
            if (!this.doOffer(queuedEvent, timeout)) {
                offered.setFalse();
                return previousCounter;
            }
            SimpleTrackedEvent trackedEvent = new SimpleTrackedEvent(queuedEvent.getId(), queuedEvent.getTimestamp());
            int newCount = previousCounter == null ? 1 : previousCounter.count() + 1;
            return new TrackedEventCounter(trackedEvent, newCount);
        });
        return offered.booleanValue();
    }

    @Override
    @Nonnull
    public Optional<QueuedEvent> poll(@Nonnull Duration timeout) throws InterruptedException {
        Objects.requireNonNull(timeout, "timeout");
        QueuedEvent polledEvent = this.queue.poll(timeout.getSeconds(), TimeUnit.SECONDS);
        if (polledEvent != null && polledEvent.getEvent().getEventType().isTrackedInQueue()) {
            String trackedEventKey = this.getTrackedEventKey(polledEvent.getEvent());
            this.trackedEvents.compute(trackedEventKey, (key, previousCounter) -> {
                if (previousCounter != null) {
                    int currentCount = previousCounter.count();
                    int newCount = currentCount - 1;
                    if (newCount == 0) {
                        return null;
                    }
                    return new TrackedEventCounter(previousCounter.latestEvent(), newCount);
                }
                return null;
            });
        }
        return Optional.ofNullable(polledEvent);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    private boolean doOffer(QueuedEvent queuedEvent, Duration timeout) {
        try {
            return this.queue.offer(queuedEvent, timeout.getSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e);
        }
    }

    private String getTrackedEventKey(IndexEvent indexEvent) {
        return indexEvent.accept(this.trackedEventKeyResolver);
    }

    private record TrackedEventCounter(@Nonnull TrackedEvent latestEvent, int count) {
        TrackedEventCounter {
            Objects.requireNonNull(latestEvent, "latestEvent");
        }
    }
}

