/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.event.queue;

import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventVisitor;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ReindexRepositoryFilesEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentIndirectlyModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryPropertiesModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserDeletedIndexEvent;

class TrackedEventKeyResolver
implements IndexEventVisitor<String> {
    TrackedEventKeyResolver() {
    }

    @Override
    public String visit(ProjectCreatedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getProjectId());
    }

    @Override
    public String visit(ProjectDeletedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getProjectId());
    }

    @Override
    public String visit(ProjectModifiedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getProjectId());
    }

    @Override
    public String visit(ReindexRepositoryFilesEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(RepositoryContentDeletedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(RepositoryContentIndirectlyModifiedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(RepositoryContentModifiedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(RepositoryCreatedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(RepositoryDeletedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(RepositoryModifiedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(RepositoryPropertiesModifiedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getRepositoryId());
    }

    @Override
    public String visit(UserDeletedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getUsername());
    }

    @Override
    public String visit(UserCreatedIndexEvent event) {
        return this.getFullyQualifiedKey(event.getEventType(), event.getUser().getName());
    }

    String getFullyQualifiedKey(EventType eventType, Object key) {
        return eventType.name() + "." + String.valueOf(key);
    }
}

