/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.filter;

import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ReindexRepositoryFilesEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentIndirectlyModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexFilterService;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilter;
import com.atlassian.bitbucket.util.MoreCollectors;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIndexFilterService
implements IndexFilterService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexFilterService.class);
    private final List<IndexingFilter> enabledFilters;
    private final String indexingExcludes;

    @Autowired
    public DefaultIndexFilterService(IndexingProperties indexingProperties, Collection<IndexingFilter> filters) {
        boolean codeIndexingEnabled = indexingProperties.getCodeIndexingEnabled();
        this.indexingExcludes = indexingProperties.getCodeIndexingExcludes();
        if (codeIndexingEnabled && this.indexingExcludes != null) {
            this.enabledFilters = (List)filters.stream().filter(this::isEnabled).collect(MoreCollectors.toImmutableList());
            if (this.enabledFilters.isEmpty()) {
                log.warn("A filter could not be found for exclude '{}'. No filtering will be applied", (Object)this.indexingExcludes);
            }
        } else {
            this.enabledFilters = Collections.singletonList(DefaultIndexFilterService.codeFilter(codeIndexingEnabled));
        }
    }

    @Override
    public boolean shouldProcess(@Nonnull IndexEvent event) {
        return this.enabledFilters.stream().allMatch(indexingFilter -> indexingFilter.filter(event));
    }

    private static IndexingFilter codeFilter(final boolean value) {
        return new IndexingFilter(){

            @Override
            public boolean filter(@Nonnull IndexEvent event) {
                return value || !this.isCodeEvent(event);
            }

            @Override
            @Nonnull
            public String getKey() {
                return "unitFilter";
            }

            private boolean isCodeEvent(IndexEvent event) {
                return event instanceof RepositoryContentModifiedIndexEvent || event instanceof RepositoryContentIndirectlyModifiedIndexEvent || event instanceof ReindexRepositoryFilesEvent;
            }
        };
    }

    private boolean isEnabled(@Nonnull IndexingFilter indexingFilter) {
        return indexingFilter.getKey().equals(this.indexingExcludes);
    }
}

