/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.filter;

import com.atlassian.bitbucket.internal.search.client.Requests;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.indexing.event.AbstractRepositoryIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.ServiceUnavailableException;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilter;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilterUtils;
import com.atlassian.bitbucket.internal.search.indexing.filter.suppliers.EscalatedRepositorySupplier;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncService;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.TermQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import com.atlassian.elasticsearch.client.search.Page;
import com.atlassian.elasticsearch.client.search.SearchSourceBuilder;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component
public class InactiveForkFilter
implements IndexingFilter {
    private static final String KEY = "undiverged-forks";
    private static final Logger log = LoggerFactory.getLogger(InactiveForkFilter.class);
    private final SearchClient searchClient;
    private final RefSyncService refSyncService;
    private final EscalatedRepositorySupplier repositorySupplier;

    @Autowired
    public InactiveForkFilter(SearchClient searchClient, RefSyncService refSyncService, EscalatedRepositorySupplier repositorySupplier) {
        this.searchClient = searchClient;
        this.refSyncService = refSyncService;
        this.repositorySupplier = repositorySupplier;
    }

    @Override
    public boolean filter(@Nonnull IndexEvent event) {
        if (IndexingFilterUtils.isRepositoryContentIndexingEvent(event)) {
            int id = ((AbstractRepositoryIndexEvent)event).getRepositoryId();
            Repository repo = this.repositorySupplier.getById(id);
            if (repo == null || !repo.isFork()) {
                return true;
            }
            RefSyncStatus status = this.refSyncService.getStatus(repo);
            if (status == null || !status.isEnabled()) {
                return true;
            }
            if (event instanceof RepositoryContentModifiedIndexEvent) {
                return !((RepositoryContentModifiedIndexEvent)event).isSynchronizationEvent();
            }
            try {
                return (Boolean)this.searchClient.execute(Requests.request(FileMapping.type()).search().source(new SearchSourceBuilder().query((QueryBuilder)new TermQueryBuilder(FileMapping.REPOSITORY_ID.fieldName()).value((Value)NumberValue.of((Number)id))).page(new Page.Builder().from(0).size(1).build())).explain(false)).flatMap(res -> Observable.just((Object)(res.getTotalHitsNumber() != 0L ? 1 : 0)), throwable -> Observable.error((Throwable)new ServiceUnavailableException("Search query failed for repo documents and will not be retried")), Observable::empty).toBlocking().first();
            }
            catch (Exception e) {
                log.info("[{}] Unable to query the search server to determine if repository should be filtered from indexing. Assuming this repository should be filtered", (Object)repo);
                return false;
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public String getKey() {
        return KEY;
    }
}

