/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.filter;

import com.atlassian.bitbucket.internal.search.indexing.event.AbstractRepositoryIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilter;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilterUtils;
import com.atlassian.bitbucket.internal.search.indexing.filter.suppliers.EscalatedRepositorySupplier;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoForksFilter
implements IndexingFilter {
    private static final String KEY = "all-forks";
    private final EscalatedRepositorySupplier repositorySupplier;

    @Autowired
    public NoForksFilter(EscalatedRepositorySupplier repositorySupplier) {
        this.repositorySupplier = repositorySupplier;
    }

    @Override
    public boolean filter(@Nonnull IndexEvent event) {
        if (IndexingFilterUtils.isRepositoryContentIndexingEvent(event)) {
            return this.internalFilter((AbstractRepositoryIndexEvent)event);
        }
        return true;
    }

    @Override
    @Nonnull
    public String getKey() {
        return KEY;
    }

    private boolean internalFilter(@Nonnull AbstractRepositoryIndexEvent event) {
        Repository repo = this.repositorySupplier.getById(event.getRepositoryId());
        return repo != null && !repo.isFork();
    }
}

