/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.filter;

import com.atlassian.bitbucket.internal.search.indexing.event.AbstractRepositoryIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilter;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilterUtils;
import com.atlassian.bitbucket.internal.search.indexing.filter.suppliers.EscalatedRepositorySupplier;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonalForksFilter
implements IndexingFilter {
    private static final String KEY = "personal-forks";
    private final EscalatedRepositorySupplier repositorySupplier;

    @Autowired
    public PersonalForksFilter(EscalatedRepositorySupplier repositorySupplier) {
        this.repositorySupplier = repositorySupplier;
    }

    @Override
    public boolean filter(@Nonnull IndexEvent event) {
        if (IndexingFilterUtils.isRepositoryContentIndexingEvent(event)) {
            return this.doFilterPersonalFork((AbstractRepositoryIndexEvent)event);
        }
        return true;
    }

    @Override
    @Nonnull
    public String getKey() {
        return KEY;
    }

    private boolean doFilterPersonalFork(AbstractRepositoryIndexEvent event) {
        Repository repo = this.repositorySupplier.getById(event.getRepositoryId());
        return repo == null || !repo.isFork() || repo.getProject().getType() != ProjectType.PERSONAL;
    }
}

