/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.filter;

import com.atlassian.bitbucket.internal.search.indexing.event.AbstractRepositoryIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilter;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexingFilterUtils;
import com.atlassian.bitbucket.internal.search.indexing.filter.suppliers.EscalatedRepositorySupplier;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncService;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncedForkFilter
implements IndexingFilter {
    private static final String KEY = "synced-forks";
    private final RefSyncService refSyncService;
    private final EscalatedRepositorySupplier repositorySupplier;

    @Autowired
    public SyncedForkFilter(EscalatedRepositorySupplier repositorySupplier, RefSyncService refSyncService) {
        this.refSyncService = refSyncService;
        this.repositorySupplier = repositorySupplier;
    }

    @Override
    public boolean filter(@Nonnull IndexEvent event) {
        if (IndexingFilterUtils.isRepositoryContentIndexingEvent(event)) {
            return this.doInternalFilter((AbstractRepositoryIndexEvent)event);
        }
        return true;
    }

    @Override
    @Nonnull
    public String getKey() {
        return KEY;
    }

    private boolean doInternalFilter(AbstractRepositoryIndexEvent event) {
        Repository repo = this.repositorySupplier.getById(event.getRepositoryId());
        if (repo == null || !repo.isFork()) {
            return true;
        }
        RefSyncStatus status = this.refSyncService.getStatus(repo);
        return status == null || !status.isEnabled();
    }
}

