/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.filter.suppliers;

import com.atlassian.bitbucket.internal.search.indexing.filter.suppliers.EscalatedRepositorySupplier;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="escalatedRepositorySupplier")
class DefaultEscalatedRepositorySupplier
implements EscalatedRepositorySupplier {
    private final RepositorySupplier delegate;
    private final SecurityService securityService;

    @Autowired
    public DefaultEscalatedRepositorySupplier(RepositorySupplier repositorySupplier, SecurityService securityService) {
        this.delegate = repositorySupplier;
        this.securityService = securityService;
    }

    @Override
    @Nullable
    public Repository getById(int id) {
        return (Repository)this.securityService.withPermission(Permission.REPO_READ, "getting repository to be filtered").call(() -> this.delegate.getById(id));
    }
}

