/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadLifecycleListener;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;

public class BlockProducerOnNext<T>
implements Observable.Operator<T, T> {
    private final String indexingThreadName;
    private final IndexingThreadLifecycleListener lifecycleListener;

    public BlockProducerOnNext(String indexingThreadName, IndexingThreadLifecycleListener lifecycleListener) {
        this.indexingThreadName = indexingThreadName;
        this.lifecycleListener = lifecycleListener;
    }

    public static <T> BlockProducerOnNext<T> create(String threadName, IndexingThreadLifecycleListener lifecycleListener) {
        return new BlockProducerOnNext<T>(threadName, lifecycleListener);
    }

    public Subscriber<T> call(Subscriber<? super T> child) {
        GatekeeperControl gatekeeperControl = new GatekeeperControl(this);
        Subscriber<? super T> flowControlSubscriber = this.createSubscriber(child, gatekeeperControl);
        child.setProducer((Producer)gatekeeperControl);
        return flowControlSubscriber;
    }

    private Subscriber<T> createSubscriber(final Subscriber<? super T> child, final GatekeeperControl gatekeeperControl) {
        Subscriber parent = new Subscriber<T>(){
            private boolean complete;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted() {
                if (!this.complete) {
                    this.complete = true;
                    child.onCompleted();
                }
                Object object = gatekeeperControl.gateKeeper;
                synchronized (object) {
                    gatekeeperControl.gateKeeper.notifyAll();
                }
            }

            public void onError(Throwable e) {
                if (!this.complete) {
                    this.complete = true;
                    try {
                        child.onError(e);
                    }
                    finally {
                        this.unsubscribe();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(T element) {
                if (child.isUnsubscribed()) {
                    if (!this.complete) {
                        this.complete = true;
                        this.onCompleted();
                    }
                    return;
                }
                if (gatekeeperControl.infinite) {
                    BlockProducerOnNext.this.lifecycleListener.onProcessingUpdate(BlockProducerOnNext.this.indexingThreadName, "Element processed in infinite mode.");
                    child.onNext(element);
                } else {
                    if (gatekeeperControl.allowedBeforeBlock.get() == 0L) {
                        Object object = gatekeeperControl.gateKeeper;
                        synchronized (object) {
                            block16: {
                                try {
                                    if (gatekeeperControl.allowedBeforeBlock.get() == 0L) {
                                        BlockProducerOnNext.this.lifecycleListener.onProcessingUpdate(BlockProducerOnNext.this.indexingThreadName, "Blocking on next element as no requests are pending.");
                                        gatekeeperControl.gateKeeper.wait();
                                    }
                                    BlockProducerOnNext.this.lifecycleListener.onProcessingUpdate(BlockProducerOnNext.this.indexingThreadName, "Unblocked and proceeding with element processing.");
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    BlockProducerOnNext.this.lifecycleListener.onProcessingUpdate(BlockProducerOnNext.this.indexingThreadName, "Interrupted while blocking");
                                    if (child.isUnsubscribed()) break block16;
                                    child.onError((Throwable)new IndexException("Over producer has been interrupted while pushing back by blocking", e));
                                }
                            }
                        }
                    }
                    if (!child.isUnsubscribed()) {
                        try {
                            child.onNext(element);
                        }
                        finally {
                            gatekeeperControl.allowedBeforeBlock.decrementAndGet();
                            if (this.complete) {
                                child.onCompleted();
                                this.unsubscribe();
                            }
                        }
                    }
                }
            }
        };
        child.add((Subscription)parent);
        return parent;
    }

    private class GatekeeperControl
    implements Producer {
        private final AtomicLong allowedBeforeBlock = new AtomicLong(0L);
        private final Object gateKeeper = new Object();
        private volatile boolean infinite;

        GatekeeperControl(BlockProducerOnNext blockProducerOnNext) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            if (n <= 0L) {
                throw new IllegalArgumentException();
            }
            if (n == Long.MAX_VALUE) {
                this.infinite = true;
                Object object = this.gateKeeper;
                synchronized (object) {
                    this.gateKeeper.notify();
                }
            }
            this.allowedBeforeBlock.addAndGet(n);
            Object object = this.gateKeeper;
            synchronized (object) {
                this.gateKeeper.notify();
            }
        }
    }
}

