/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.indexing.content.File;
import com.atlassian.bitbucket.internal.search.indexing.content.TextFile;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.internal.operators.BackpressureUtils;

public class BufferOnSizeAndCount
implements Observable.Operator<List<File>, File> {
    private static final Logger log = LoggerFactory.getLogger(BufferOnSizeAndCount.class);
    private final int maxBufferSize;
    private final int maxItemsPerBuffer;

    public BufferOnSizeAndCount(int maxItemsPerBuffer, int maxBufferSize) {
        this.maxItemsPerBuffer = maxItemsPerBuffer;
        this.maxBufferSize = maxBufferSize;
    }

    public Subscriber<? super File> call(Subscriber<? super List<File>> child) {
        BufferingSubscriber parent = new BufferingSubscriber(child);
        child.add((Subscription)parent);
        child.setProducer(parent.createProducer());
        return parent;
    }

    private class BufferingSubscriber
    extends Subscriber<File> {
        private final List<File> buffer;
        private final Subscriber<? super List<File>> child;
        private long bufferContentSize;

        private BufferingSubscriber(Subscriber<? super List<File>> child) {
            super(child, false);
            this.buffer = new ArrayList<File>(BufferOnSizeAndCount.this.maxItemsPerBuffer);
            this.bufferContentSize = 0L;
            this.child = child;
            this.request(0L);
        }

        public void onCompleted() {
            try {
                if (!this.child.isUnsubscribed()) {
                    if (!this.buffer.isEmpty()) {
                        this.logBufferInfo("Flushing remaining {} items with file content size {}");
                        ImmutableList remaining = ImmutableList.copyOf(this.buffer);
                        this.child.onNext((Object)remaining);
                    }
                    this.child.onCompleted();
                }
            }
            finally {
                this.clearBuffer();
            }
        }

        public void onError(Throwable e) {
            this.clearBuffer();
            if (!this.child.isUnsubscribed()) {
                this.child.onError(e);
            }
        }

        public void onNext(File file) {
            boolean exceedsSizeOrCount;
            boolean exceedsCount = this.buffer.size() + 1 > BufferOnSizeAndCount.this.maxItemsPerBuffer;
            long size = this.getSize(file);
            boolean bl = exceedsSizeOrCount = exceedsCount || this.bufferContentSize + size > (long)BufferOnSizeAndCount.this.maxBufferSize;
            if (exceedsSizeOrCount && !this.buffer.isEmpty() && !this.child.isUnsubscribed()) {
                this.logBufferInfo("Flushing {} item(s) with file content size {}");
                ImmutableList copy = ImmutableList.copyOf(this.buffer);
                this.child.onNext((Object)copy);
                this.clearBuffer();
            }
            this.buffer.add(file);
            this.bufferContentSize += size;
        }

        Producer createProducer() {
            return n -> {
                if (n < 0L) {
                    throw new IllegalArgumentException("n >= 0 required but it was " + n);
                }
                if (n != 0L) {
                    long u = BackpressureUtils.multiplyCap((long)n, (long)BufferOnSizeAndCount.this.maxItemsPerBuffer);
                    this.request(u);
                }
            };
        }

        private void clearBuffer() {
            this.buffer.clear();
            this.bufferContentSize = 0L;
        }

        private String formatSize(long size) {
            if (size < 1024L) {
                return size + " B";
            }
            return size / 1024L + " KiB";
        }

        private long getSize(File file) {
            TextFile textFile;
            if (file instanceof TextFile && (textFile = (TextFile)file).getContent().isPresent()) {
                return textFile.getSize();
            }
            return 0L;
        }

        private void logBufferInfo(String messageFormat) {
            if (log.isDebugEnabled()) {
                String formattedSize = this.formatSize(this.bufferContentSize);
                log.debug(messageFormat, (Object)this.buffer.size(), (Object)formattedSize);
            }
        }
    }
}

