/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryContextDefinition;
import com.atlassian.bitbucket.internal.search.indexing.content.CommitNotFoundException;
import com.atlassian.bitbucket.internal.search.indexing.content.ContentResult;
import com.atlassian.bitbucket.internal.search.indexing.content.ContentService;
import com.atlassian.bitbucket.internal.search.indexing.content.File;
import com.atlassian.bitbucket.internal.search.indexing.content.RepositoryHandle;
import com.atlassian.bitbucket.internal.search.indexing.content.SimpleContentRequest;
import com.atlassian.bitbucket.internal.search.indexing.content.SimpleRepositoryHandle;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.AlreadyClaimedException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.AlreadyExistsException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.NotFoundException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.ServiceUnavailableException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.UnrecoverableIndexException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.VersionConflictException;
import com.atlassian.bitbucket.internal.search.indexing.indexer.BlockProducerOnNext;
import com.atlassian.bitbucket.internal.search.indexing.indexer.BufferOnSizeAndCount;
import com.atlassian.bitbucket.internal.search.indexing.indexer.FileRequestStatistics;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexFilesRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexFilesResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexRequestDispatcher;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexService;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexState;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexStateService;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexingSettings;
import com.atlassian.bitbucket.internal.search.indexing.indexer.ProjectPropertiesIndexRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RemoveResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RepositoryPropertiesIndexRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.UpdateResult;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadLifecycleListener;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.text.MessageFormat;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component
public class DefaultIndexService
implements IndexService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexService.class);
    private final Clock clock;
    private final ContentService contentService;
    private final IndexRequestDispatcher documentDispatcher;
    private final IndexStateService indexStateService;
    private final IndexingSettings indexingSettings;
    private final IndexingThreadLifecycleListener lifecycleListener;

    @Autowired
    public DefaultIndexService(IndexingSettings indexingSettings, ContentService contentService, IndexRequestDispatcher documentDispatcher, IndexStateService indexStateService, IndexingThreadLifecycleListener lifecycleListener, Clock clock) {
        this.indexingSettings = indexingSettings;
        this.documentDispatcher = documentDispatcher;
        this.contentService = contentService;
        this.indexStateService = indexStateService;
        this.clock = clock;
        this.lifecycleListener = lifecycleListener;
    }

    @Override
    public boolean exceedsMaximumRetries(@Nonnull IndexState indexState) {
        Objects.requireNonNull(indexState, "indexState");
        return indexState.getRetries() > this.indexingSettings.getIndexRetries();
    }

    @Override
    @Nonnull
    public Observable<IndexFilesResult> indexFiles(@Nonnull IndexFilesRequest indexRequest) {
        Objects.requireNonNull(indexRequest, "indexRequest");
        RepositoryContextDefinition repository = indexRequest.getRepositoryContextDefinition();
        if (!this.contentService.supportsStreamingFiles(this.repositoryHandle(indexRequest))) {
            log.debug("Streaming file content is not supported for the repository with id {}, skipping indexing of files", (Object)repository.getRepositoryId());
            return Observable.just((Object)IndexFilesResult.builder().build());
        }
        return this.loadIndexState(repository.getRepositoryId()).onErrorResumeNext(e -> this.createIndexStateIfNotFound(repository, (Throwable)e)).flatMap(this::canClaimIndexState).flatMap(indexState -> this.indexFilesWithIndexState(indexRequest, (IndexState)indexState));
    }

    @Override
    @Nonnull
    public Observable<IndexResult> indexProjectProperties(@Nonnull ProjectPropertiesIndexRequest projectPropertiesIndexRequest) {
        return this.documentDispatcher.indexProjectProperties(Objects.requireNonNull(projectPropertiesIndexRequest, "projectPropertiesIndexRequest"));
    }

    @Override
    @Nonnull
    public Observable<IndexResult> indexRepositoryProperties(@Nonnull RepositoryPropertiesIndexRequest repositoryPropertiesIndexRequest) {
        return this.documentDispatcher.indexRepositoryProperties(Objects.requireNonNull(repositoryPropertiesIndexRequest, "repositoryPropertiesIndexRequest"));
    }

    @Override
    @Nonnull
    public Observable<RemoveResult> removeFiles(int repositoryId) {
        return this.loadIndexState(repositoryId).flatMap(indexState -> this.removeFilesWithIndexState(repositoryId, (IndexState)indexState));
    }

    @Override
    @Nonnull
    public Observable<Boolean> removeProjectProperties(int projectId) {
        return this.documentDispatcher.removeProjectProperties(projectId);
    }

    @Override
    @Nonnull
    public Observable<Boolean> removeRepositoryProperties(int repositoryId) {
        return this.documentDispatcher.removeRepositoryProperties(repositoryId);
    }

    @Override
    @Nonnull
    public Observable<UpdateResult> updateFiles(@Nonnull RepositoryContextDefinition repositoryContextDefinition) {
        return this.loadIndexState(repositoryContextDefinition.getRepositoryId()).flatMap(indexState -> this.updateFilesWithIndexState(repositoryContextDefinition, (IndexState)indexState));
    }

    private Observable<FileRequestStatistics> bulkIndexFiles(RepositoryContextDefinition repositoryContextDefinition, Observable<File> files) {
        this.lifecycleListener.onProcessingUpdate("Starting bulk file indexing for: %s".formatted(repositoryContextDefinition));
        return files.lift(BlockProducerOnNext.create(Thread.currentThread().getName(), this.lifecycleListener)).lift((Observable.Operator)new BufferOnSizeAndCount(this.indexingSettings.getItemsPerBatch(), this.indexingSettings.getBatchContentSizeBytes())).flatMap(fileList -> this.documentDispatcher.bulkIndexFileContents((List<File>)fileList, repositoryContextDefinition)).reduce((Object)FileRequestStatistics.builder().build(), this::combineIndexResults);
    }

    private Observable<IndexState> canClaimIndexState(IndexState indexState) {
        Optional<Instant> maybeClaimTime = indexState.getClaimTimestamp();
        if (maybeClaimTime.isPresent()) {
            Instant claimTime = maybeClaimTime.get();
            if (this.clock.instant().isBefore(this.claimExpiry(claimTime))) {
                return Observable.error((Throwable)new AlreadyClaimedException(MessageFormat.format("The repository with id {0} has already been claimed, the claim is valid until {1}", indexState.getRepositoryContextDefinition().getRepositoryId(), this.claimExpiry(claimTime))));
            }
        }
        return Observable.just((Object)indexState);
    }

    private Instant claimExpiry(Instant claimTime) {
        return claimTime.plus(this.indexingSettings.getClaimDuration());
    }

    private Observable<IndexState> claimIndexState(IndexState indexState) {
        return this.canClaimIndexState(indexState).flatMap(tryClaim -> {
            Instant newTimestamp = this.clock.instant();
            Optional<Instant> existingTimestamp = indexState.getClaimTimestamp();
            existingTimestamp.ifPresent(instant -> {
                Instant expiry = this.claimExpiry((Instant)instant);
                log.warn("The repository with id {} was claimed but the claim has expired at {}. Overriding claim with {}.", new Object[]{indexState.getRepositoryContextDefinition().getRepositoryId(), expiry, newTimestamp});
            });
            IndexState newIndexState = IndexState.builder(tryClaim).claimTimestamp(newTimestamp).build();
            return this.saveIndexState(newIndexState);
        });
    }

    private RemoveResult combineDeleteResults(RemoveResult a, RemoveResult b) {
        return RemoveResult.builder().add(a).add(b).build();
    }

    private FileRequestStatistics combineIndexResults(FileRequestStatistics a, FileRequestStatistics b) {
        FileRequestStatistics.Builder builder = FileRequestStatistics.builder();
        builder.add(a);
        builder.add(b);
        return builder.build();
    }

    private UpdateResult combineUpdateResults(UpdateResult a, UpdateResult b) {
        return UpdateResult.builder().add(a).add(b).build();
    }

    private Observable<IndexState> createIndexStateIfNotFound(RepositoryContextDefinition repository, Throwable e) {
        if (e instanceof NotFoundException) {
            return Observable.just((Object)IndexState.builder().repositoryContextDefinition(repository).build());
        }
        return Observable.error((Throwable)e);
    }

    private Observable<IndexFilesResult> indexFilesWithIndexState(IndexFilesRequest indexRequest, IndexState indexState) {
        if (this.exceedsMaximumRetries(indexState)) {
            log.debug("Indexing for repository with id {} has already reached maximum retries ({}), not attempting again", (Object)indexRequest.getRepositoryContextDefinition().getRepositoryId(), (Object)this.indexingSettings.getIndexRetries());
            return Observable.just((Object)IndexFilesResult.builder().build());
        }
        RepositoryHandle repositoryHandle = this.repositoryHandle(indexRequest);
        Either<Exception, Optional<String>> result = this.contentService.getDefaultBranchCommitId(repositoryHandle);
        if (result.isLeft()) {
            return Observable.error((Throwable)((Throwable)result.left().get()));
        }
        Optional optionalTipCommitId = (Optional)result.getOrElse(Optional.empty());
        if (!optionalTipCommitId.isPresent()) {
            return Observable.just((Object)IndexFilesResult.builder().build());
        }
        String tipCommitId = (String)optionalTipCommitId.get();
        if (indexState.getIndexedCommitId().equals(Optional.of(tipCommitId))) {
            return Observable.just((Object)IndexFilesResult.builder().build());
        }
        Optional<String> indexStateToCommitId = indexState.getToCommitId();
        if (indexStateToCommitId.isPresent()) {
            UnitOfWork unitOfWork = new UnitOfWork(indexStateToCommitId.get(), true);
            return this.claimIndexState(indexState).flatMap(claimedState -> this.processUnitOfWork(indexRequest, (IndexState)claimedState, unitOfWork));
        }
        UnitOfWork unitOfWork = new UnitOfWork(tipCommitId, false);
        IndexState newIndexState = IndexState.builder(indexState).toCommitId(tipCommitId).build();
        return this.claimIndexState(newIndexState).flatMap(savedIndexState -> this.processUnitOfWork(indexRequest, (IndexState)savedIndexState, unitOfWork));
    }

    private Observable<IndexState> loadIndexState(int repositoryId) {
        return this.indexStateService.load(repositoryId);
    }

    private Observable<IndexFilesResult> processUnitOfWork(IndexFilesRequest indexRequest, IndexState indexState, UnitOfWork unitOfWork) {
        this.lifecycleListener.onProcessingUpdate("Processing unit of work for: %s %s %s".formatted(indexRequest, indexState, unitOfWork));
        SimpleContentRequest.Builder requestBuilder = SimpleContentRequest.builder().repositoryHandle(this.repositoryHandle(indexRequest)).commitId(unitOfWork.getCommitIdToIndex());
        indexState.getIndexedCommitId().ifPresent(requestBuilder::previousCommitId);
        SimpleContentRequest contentRequest = requestBuilder.build();
        this.lifecycleListener.onProcessingUpdate("Streaming files for: %s".formatted(contentRequest));
        ContentResult contentResult = this.contentService.streamFilesFromRepository(contentRequest);
        Observable<FileRequestStatistics> indexResult = this.bulkIndexFiles(indexRequest.getRepositoryContextDefinition(), contentResult.getFiles());
        return indexResult.flatMap(result -> this.updateIndexState((FileRequestStatistics)result, indexState, unitOfWork), error -> this.updateIndexStateForError(indexState, (Throwable)error), Observable::empty);
    }

    private Observable<IndexState> releaseIndexState(IndexState indexState) {
        IndexState releasedState = IndexState.builder(indexState).releaseClaim().build();
        return this.saveIndexState(releasedState);
    }

    private <T> Observable<T> releaseIndexStateForError(IndexState indexState, Throwable exception) {
        return this.releaseIndexState(indexState).onErrorResumeNext(saveException -> {
            exception.addSuppressed((Throwable)saveException);
            return Observable.error((Throwable)exception);
        }).flatMap(releasedState -> Observable.error((Throwable)exception));
    }

    private Observable<RemoveResult> removeFilesWithIndexState(int repositoryId, IndexState indexState) {
        return this.claimIndexState(indexState).flatMap(claimedState -> this.documentDispatcher.getAllFileIdsForRepository(repositoryId, this.indexingSettings.getItemsPerBatch()).buffer(this.indexingSettings.getItemsPerBatch()).flatMap(this.documentDispatcher::bulkDeleteFiles).reduce((Object)RemoveResult.builder().build(), this::combineDeleteResults).flatMap(result -> !result.getRequestStatistics().hasErrors() ? Observable.just((Object)result) : this.releaseIndexStateForError((IndexState)claimedState, new IndexException(MessageFormat.format("Deletion of files for repository with id {0} failed: {1}", claimedState.getRepositoryContextDefinition().getRepositoryId(), result.getRequestStatistics()))), error -> this.releaseIndexStateForError((IndexState)claimedState, (Throwable)error), Observable::empty).flatMap(result -> this.indexStateService.delete((IndexState)claimedState).map(deleted -> result)));
    }

    private RepositoryHandle repositoryHandle(IndexFilesRequest indexRequest) {
        return SimpleRepositoryHandle.builder().id(indexRequest.getRepositoryContextDefinition().getRepositoryId()).path(indexRequest.getRepositoryPath().orElse(null)).build();
    }

    private Observable<IndexState> saveIndexState(IndexState indexState) {
        return this.indexStateService.save(indexState).onErrorResumeNext(error -> {
            if (error instanceof AlreadyExistsException || error instanceof VersionConflictException) {
                return Observable.error((Throwable)new IndexException(MessageFormat.format("Indexing for repository with id {0} failed because index state could not be saved", indexState.getRepositoryContextDefinition().getRepositoryId()), (Throwable)error));
            }
            return Observable.error((Throwable)error);
        });
    }

    private Observable<UpdateResult> updateFilesWithIndexState(RepositoryContextDefinition repositoryContextDefinition, IndexState indexState) {
        return this.claimIndexState(indexState).flatMap(claimedState -> this.documentDispatcher.getAllFileIdsForRepository(repositoryContextDefinition.getRepositoryId(), this.indexingSettings.getItemsPerBatch()).buffer(this.indexingSettings.getItemsPerBatch()).flatMap(docIds -> this.documentDispatcher.bulkPartialUpdateFiles((List<String>)docIds, repositoryContextDefinition)).reduce((Object)UpdateResult.builder().build(), this::combineUpdateResults).flatMap(result -> !result.getRequestStatistics().hasErrors() ? Observable.just((Object)result) : this.releaseIndexStateForError((IndexState)claimedState, new IndexException(MessageFormat.format("Modification of files for repository with id {0} failed: {1}", claimedState.getRepositoryContextDefinition().getRepositoryId(), result.getRequestStatistics()))), error -> this.releaseIndexStateForError((IndexState)claimedState, (Throwable)error), Observable::empty).flatMap(result -> {
            IndexState newIndexState = IndexState.builder(claimedState).repositoryContextDefinition(repositoryContextDefinition).build();
            return this.releaseIndexState(newIndexState).map(releasedState -> result);
        }));
    }

    private Observable<IndexFilesResult> updateIndexState(FileRequestStatistics stats, IndexState indexState, UnitOfWork unitOfWork) {
        if (stats.getNumFailedRequests() > 0) {
            IndexException error = new IndexException("Bulk indexing of files failed: " + String.valueOf(stats));
            return this.updateIndexStateForError(indexState, error);
        }
        if (stats.getNumPartiallyFailedRequests() > 0) {
            log.warn("{} file{} failed to index correctly.", (Object)stats.getNumPartiallyFailedRequests(), (Object)(stats.getNumPartiallyFailedRequests() == 1 ? "" : "s"));
        }
        IndexState newIndexState = IndexState.builder(indexState).indexedCommitId(unitOfWork.getCommitIdToIndex()).toCommitId(null).retries(0).indexingError(null).build();
        return this.releaseIndexState(newIndexState).map(saved -> IndexFilesResult.builder().requestStatistics(stats).moreIndexingRequired(unitOfWork.isResumed()).build());
    }

    private Observable<IndexFilesResult> updateIndexStateForError(IndexState indexState, Throwable error) {
        boolean serviceUnavailable = error instanceof ServiceUnavailableException;
        IndexState.Builder builder = IndexState.builder(indexState);
        if (!serviceUnavailable) {
            builder.retries(indexState.getRetries() + 1);
        }
        builder.indexingError(String.format("%s : %s", error.getMessage(), Arrays.toString(error.getStackTrace())));
        IndexState newIndexState = builder.build();
        return this.releaseIndexState(newIndexState).flatMap(saved -> {
            if (error instanceof CommitNotFoundException) {
                return Observable.error((Throwable)error);
            }
            if (serviceUnavailable) {
                return Observable.error((Throwable)error);
            }
            int repositoryId = indexState.getRepositoryContextDefinition().getRepositoryId();
            if (this.exceedsMaximumRetries(newIndexState)) {
                return Observable.error((Throwable)new UnrecoverableIndexException(MessageFormat.format("Indexing for repository with id {0} failed and has reached maximum retries ({1})", repositoryId, this.indexingSettings.getIndexRetries()), error));
            }
            return Observable.error((Throwable)new IndexException(MessageFormat.format("Indexing for repository with id {0} failed and should be retried", repositoryId), error));
        });
    }

    private static class UnitOfWork {
        private final String commitIdToIndex;
        private final boolean resumed;

        public UnitOfWork(String commitIdToIndex, boolean resumed) {
            this.commitIdToIndex = commitIdToIndex;
            this.resumed = resumed;
        }

        public String getCommitIdToIndex() {
            return this.commitIdToIndex;
        }

        public boolean isResumed() {
            return this.resumed;
        }

        public String toString() {
            return "UnitOfWork{commitIdToIndex=" + this.commitIdToIndex + ", resumed=" + this.resumed + "}";
        }
    }
}

