/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryContextDefinition;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexStrategy;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class IndexFilesRequest {
    private final IndexStrategy indexStrategy;
    private final RepositoryContextDefinition repositoryContextDefinition;
    private final Path repositoryPath;

    private IndexFilesRequest(Builder builder) {
        this.indexStrategy = builder.indexStrategy;
        this.repositoryContextDefinition = builder.repositoryContext;
        this.repositoryPath = builder.repositoryPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFilesRequest that = (IndexFilesRequest)o;
        return this.indexStrategy == that.indexStrategy && Objects.equals(this.repositoryPath, that.repositoryPath) && Objects.equals(this.repositoryContextDefinition, that.repositoryContextDefinition);
    }

    @Nonnull
    public IndexStrategy getIndexStrategy() {
        return this.indexStrategy;
    }

    @Nonnull
    public RepositoryContextDefinition getRepositoryContextDefinition() {
        return this.repositoryContextDefinition;
    }

    @Nonnull
    public Optional<Path> getRepositoryPath() {
        return Optional.ofNullable(this.repositoryPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexStrategy, this.repositoryPath, this.repositoryContextDefinition});
    }

    public String toString() {
        return "RepositoryContentIndexRequest{indexStrategy=" + String.valueOf((Object)this.indexStrategy) + ", repositoryPath=" + String.valueOf(this.repositoryPath) + ", repositoryContextDefinition=" + String.valueOf(this.repositoryContextDefinition) + "}";
    }

    public static final class Builder {
        private IndexStrategy indexStrategy;
        private RepositoryContextDefinition repositoryContext;
        private Path repositoryPath;

        private Builder() {
        }

        @Nonnull
        public IndexFilesRequest build() {
            return new IndexFilesRequest(this);
        }

        @Nonnull
        public Builder indexStrategy(@Nonnull IndexStrategy indexStrategy) {
            this.indexStrategy = Objects.requireNonNull(indexStrategy, "indexStrategy");
            return this;
        }

        @Nonnull
        public Builder repositoryContext(@Nonnull RepositoryContextDefinition repositoryContext) {
            this.repositoryContext = Objects.requireNonNull(repositoryContext, "repositoryContext");
            return this;
        }

        @Nonnull
        public Builder repositoryPath(@Nonnull Path repositoryPath) {
            this.repositoryPath = Objects.requireNonNull(repositoryPath, "repositoryPath");
            return this;
        }
    }
}

