/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.indexing.indexer.FileRequestStatistics;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RequestStatistics;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class IndexFilesResult {
    private final boolean moreIndexingRequired;
    private final FileRequestStatistics requestStatistics;

    private IndexFilesResult(Builder builder) {
        this.requestStatistics = Objects.requireNonNull(builder.requestStatistics, "requestStatistics");
        this.moreIndexingRequired = builder.moreIndexingRequired;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public RequestStatistics getRequestStatistics() {
        return this.requestStatistics;
    }

    public boolean isMoreIndexingRequired() {
        return this.moreIndexingRequired;
    }

    public String toString() {
        return "IndexFilesResult{moreIndexingRequired=" + this.moreIndexingRequired + ", requestStatistics=" + String.valueOf(this.requestStatistics) + "}";
    }

    public static class Builder {
        private boolean moreIndexingRequired;
        private FileRequestStatistics requestStatistics = FileRequestStatistics.builder().build();

        private Builder() {
        }

        @Nonnull
        public Builder add(IndexFilesResult that) {
            FileRequestStatistics.Builder builder = FileRequestStatistics.builder();
            builder.add(this.requestStatistics);
            builder.add(Objects.requireNonNull(that, (String)"that").requestStatistics);
            this.requestStatistics = builder.build();
            return this;
        }

        @Nonnull
        public IndexFilesResult build() {
            return new IndexFilesResult(this);
        }

        @Nonnull
        public Builder moreIndexingRequired(boolean value) {
            this.moreIndexingRequired = value;
            return this;
        }

        @Nonnull
        public Builder requestStatistics(@Nonnull FileRequestStatistics value) {
            this.requestStatistics = Objects.requireNonNull(value, "requestStatistics");
            return this;
        }
    }
}

