/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.dmz.repositorymanagement.DmzRepositoryManagementService;
import com.atlassian.bitbucket.internal.search.client.Requests;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.ProjectMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryContextDefinition;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.common.util.Filenames;
import com.atlassian.bitbucket.internal.search.indexing.content.ChangeType;
import com.atlassian.bitbucket.internal.search.indexing.content.File;
import com.atlassian.bitbucket.internal.search.indexing.content.TextFile;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.ServiceUnavailableException;
import com.atlassian.bitbucket.internal.search.indexing.indexer.DefaultIndexService;
import com.atlassian.bitbucket.internal.search.indexing.indexer.FileRequestStatistics;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.ProjectPropertiesIndexRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RemoveResult;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RepositoryPropertiesIndexRequest;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RepositoryTimestampAccuracy;
import com.atlassian.bitbucket.internal.search.indexing.indexer.RequestStatistics;
import com.atlassian.bitbucket.internal.search.indexing.indexer.UpdateResult;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadLifecycleListener;
import com.atlassian.bitbucket.internal.search.indexing.util.ElderScroll;
import com.atlassian.bitbucket.internal.search.indexing.util.SearchUtil;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.content.ArrayContent;
import com.atlassian.elasticsearch.client.content.BooleanValueContent;
import com.atlassian.elasticsearch.client.content.Content;
import com.atlassian.elasticsearch.client.content.ContentBuilder;
import com.atlassian.elasticsearch.client.content.NumberValueContent;
import com.atlassian.elasticsearch.client.content.ObjectContentBuilder;
import com.atlassian.elasticsearch.client.content.StringValueContent;
import com.atlassian.elasticsearch.client.document.BulkActionBuilder;
import com.atlassian.elasticsearch.client.document.BulkDeleteActionBuilder;
import com.atlassian.elasticsearch.client.document.BulkRequestBuilder;
import com.atlassian.elasticsearch.client.document.BulkResponse;
import com.atlassian.elasticsearch.client.document.BulkResponseItem;
import com.atlassian.elasticsearch.client.document.BulkUpdateActionBuilder;
import com.atlassian.elasticsearch.client.document.DeleteRequestBuilder;
import com.atlassian.elasticsearch.client.document.IndexRequestBuilder;
import com.atlassian.elasticsearch.client.document.IndexedDocumentResponse;
import com.atlassian.elasticsearch.client.document.UpdateDocRequestBuilder;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.TermQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import com.atlassian.elasticsearch.client.request.RequestBuilder;
import com.atlassian.elasticsearch.client.request.Response;
import com.atlassian.elasticsearch.client.search.Hit;
import com.atlassian.elasticsearch.client.search.Page;
import com.atlassian.elasticsearch.client.search.SearchSourceBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.io.BaseEncoding;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component
public class IndexRequestDispatcher {
    public static final String CONFIG_PROP_ACTIVITY_ACCURACY = "plugin.search.indexing.repository-timestamp-accuracy";
    private static final String DOCUMENT_ID_DELIMITER = "_";
    private static final int MAX_DOCUMENT_ID_LENGTH = 512;
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexService.class);
    private final SearchClient client;
    private final MessageDigest digest;
    private final IndexingThreadLifecycleListener lifecycleListener;
    private final PermissionService permissionService;
    private final DmzRepositoryManagementService repositoryManagementService;
    private final RepositoryTimestampAccuracy repositoryTimestampAccuracy;

    @Autowired
    public IndexRequestDispatcher(@Nonnull ApplicationPropertiesService applicationPropertiesService, @Nonnull SearchClient client, @Nonnull IndexingThreadLifecycleListener lifecycleListener, @Nonnull PermissionService permissionService, @Nonnull DmzRepositoryManagementService repositoryManagementService) {
        this.client = client;
        this.lifecycleListener = lifecycleListener;
        this.permissionService = permissionService;
        this.repositoryManagementService = repositoryManagementService;
        try {
            this.digest = MessageDigest.getInstance("MD5");
            this.repositoryTimestampAccuracy = Optional.ofNullable(applicationPropertiesService.getPluginProperty(CONFIG_PROP_ACTIVITY_ACCURACY)).map(value -> value.toUpperCase(Locale.US)).map(RepositoryTimestampAccuracy::fromId).orElse(RepositoryTimestampAccuracy.BEST_EFFORT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IndexException("Error initializing digest", e);
        }
        catch (IllegalArgumentException e) {
            throw new IndexException("Error initializing timestamp accuracy", e);
        }
    }

    Observable<RemoveResult> bulkDeleteFiles(List<String> documentIds) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        RequestStatistics.Builder statistics = RequestStatistics.builder();
        statistics.incrementNumRequests();
        statistics.incrementNumDocumentActions(documentIds.size());
        List<BulkDeleteActionBuilder> deletes = documentIds.stream().map(id -> ES.bulkDelete().id(id)).collect(Collectors.toList());
        BulkRequestBuilder builder = Requests.request(FileMapping.type()).bulk();
        deletes.forEach(arg_0 -> ((BulkRequestBuilder)builder).action(arg_0));
        this.lifecycleListener.onProcessingUpdate("Deleting %d file(s)".formatted(documentIds.size()));
        return this.executeHandleUnavailable((RequestBuilder)builder).flatMap(res -> this.createRemoveResultFromBatch((BulkResponse)res, statistics, stopwatch, documentIds));
    }

    Observable<FileRequestStatistics> bulkIndexFileContents(List<File> files, RepositoryContextDefinition repositoryDefinition) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        FileRequestStatistics.Builder statistics = FileRequestStatistics.builder();
        statistics.incrementNumRequests();
        statistics.incrementNumDocumentActions(files.size());
        statistics.incrementFileContentBytes(files.stream().mapToLong(File::getSize).sum());
        BulkRequestBuilder builder = Requests.request(FileMapping.type()).bulk();
        for (File file2 : files) {
            BulkActionBuilder bulkActionBuilder = this.toJson(file2, repositoryDefinition);
            builder.action(bulkActionBuilder);
        }
        List documentIds = files.stream().map(file -> this.generateContentId((File)file, repositoryDefinition)).collect(Collectors.toList());
        this.lifecycleListener.onProcessingUpdate("Indexing %d files for %s".formatted(files.size(), repositoryDefinition));
        return this.executeHandleUnavailable((RequestBuilder)builder).map(response -> this.createIndexResultFromBatch((BulkResponse)response, statistics, stopwatch, documentIds));
    }

    Observable<UpdateResult> bulkPartialUpdateFiles(List<String> documentIds, RepositoryContextDefinition repositoryDefinition) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        RequestStatistics.Builder statistics = RequestStatistics.builder();
        statistics.incrementNumRequests();
        statistics.incrementNumDocumentActions(documentIds.size());
        List<BulkUpdateActionBuilder> updateActions = this.transformDocumentIdsIntoUpdateActions(documentIds, repositoryDefinition);
        BulkRequestBuilder builder = Requests.request(FileMapping.type()).bulk();
        updateActions.forEach(arg_0 -> ((BulkRequestBuilder)builder).action(arg_0));
        this.lifecycleListener.onProcessingUpdate("Partially updating %d files for %s".formatted(documentIds.size(), repositoryDefinition));
        return this.executeHandleUnavailable((RequestBuilder)builder).map(response -> this.createUpdateResultFromBatch((BulkResponse)response, statistics, stopwatch, documentIds));
    }

    Observable<String> getAllFileIdsForRepository(int repositoryId, int pageSize) {
        Page pageRq = ES.page().size(pageSize).build();
        TermQueryBuilder termQuery = ES.termQuery((String)FileMapping.REPOSITORY_ID.fieldName()).value((Value)NumberValue.of((Number)repositoryId));
        SearchSourceBuilder searchSourceBuilder = ES.searchSource().query((QueryBuilder)ES.boolQuery().filter((QueryBuilder)termQuery)).sort("_doc").source(false).page(pageRq);
        return new ElderScroll(this.client).search(searchSourceBuilder, FileMapping.type(), Duration.ofMinutes(5L)).map(Hit::getId);
    }

    Observable<IndexResult> indexProjectProperties(ProjectPropertiesIndexRequest projectPropertiesIndexRequest) {
        Project project = projectPropertiesIndexRequest.getProject();
        ObjectContentBuilder objectContentBuilder = ES.objectContent().with(ProjectMapping.KEY.fieldName(), project.getKey()).with(ProjectMapping.NAME.fieldName(), project.getName()).with(ProjectMapping.PUBLIC.fieldName(), project.isPublic());
        IndexRequestBuilder builder = Requests.request(ProjectMapping.type()).id(String.valueOf(project.getId())).index().source((ContentBuilder)objectContentBuilder);
        this.lifecycleListener.onProcessingUpdate("Indexing project with details: %s".formatted(projectPropertiesIndexRequest));
        return this.executeHandleUnavailable((RequestBuilder)builder).flatMap(this::convertIndexResponse);
    }

    Observable<IndexResult> indexRepositoryProperties(RepositoryPropertiesIndexRequest repositoryPropertiesIndexRequest) {
        Long size;
        Date recentActivity;
        String repositoryDescription;
        Repository repository = repositoryPropertiesIndexRequest.getRepository();
        Project project = repository.getProject();
        ObjectContentBuilder repositorySource = ES.objectContent().with(RepositoryMapping.SLUG.fieldName(), repository.getSlug()).with(RepositoryMapping.NAME.fieldName(), repository.getName()).with(RepositoryMapping.QUICK_SEARCH_REPOSITORY_NAME.fieldName(), repository.getName()).with(RepositoryMapping.PUBLIC.fieldName(), this.permissionService.isPubliclyAccessible(repository)).with(RepositoryMapping.FORK.fieldName(), repository.isFork()).with(RepositoryMapping.QUICK_SEARCH_PROJECT_NAME.fieldName(), project.getName()).with(RepositoryMapping.PROJECT_ID.fieldName(), (Number)project.getId()).with(RepositoryMapping.HIERARCHY_ID.fieldName(), repository.getHierarchyId()).with(RepositoryMapping.PROJECT_TYPE.fieldName(), (Number)project.getType().getId()).with(RepositoryMapping.ARCHIVED.fieldName(), repository.isArchived());
        Repository origin = repository.getOrigin();
        if (origin != null) {
            repositorySource.with(RepositoryMapping.ORIGIN_ID.fieldName(), (Number)origin.getId());
        }
        if ((repositoryDescription = repository.getDescription()) != null) {
            repositorySource.with(RepositoryMapping.QUICK_SEARCH_REPOSITORY_DESCRIPTION.fieldName(), repositoryDescription);
        }
        if ((recentActivity = this.getRecentActivity(repositoryPropertiesIndexRequest)) != null) {
            repositorySource.with(RepositoryMapping.RECENT_ACTIVITY.fieldName(), (Number)recentActivity.getTime());
        }
        if ((size = repositoryPropertiesIndexRequest.getSize()) != null) {
            repositorySource.with(RepositoryMapping.SIZE.fieldName(), (Number)size);
        }
        if (project.getType() == ProjectType.PERSONAL) {
            repositorySource.with(RepositoryMapping.USER_ACTIVE.fieldName(), ((PersonalProject)project).getOwner().isActive());
        }
        UpdateDocRequestBuilder builder = Requests.request(RepositoryMapping.type()).id(String.valueOf(repository.getId())).update().doc(repositorySource).upsert(repositorySource);
        this.lifecycleListener.onProcessingUpdate("Indexing repository with details: %s".formatted(repositoryPropertiesIndexRequest));
        return this.executeHandleUnavailable((RequestBuilder)builder).flatMap(this::convertIndexResponse);
    }

    Observable<Boolean> removeProjectProperties(int projectId) {
        DeleteRequestBuilder deleteRequest = Requests.request(ProjectMapping.type()).id(String.valueOf(projectId)).delete();
        this.lifecycleListener.onProcessingUpdate("Removing project properties for project ID: %d".formatted(projectId));
        return this.executeHandleUnavailable((RequestBuilder)deleteRequest).map(Response::isStatusSuccess);
    }

    Observable<Boolean> removeRepositoryProperties(int repositoryId) {
        DeleteRequestBuilder deleteRequest = Requests.request(RepositoryMapping.type()).id(String.valueOf(repositoryId)).delete();
        this.lifecycleListener.onProcessingUpdate("Removing repository properties for repository ID: %d".formatted(repositoryId));
        return this.executeHandleUnavailable((RequestBuilder)deleteRequest).map(Response::isStatusSuccess);
    }

    @VisibleForTesting
    Observable<IndexResult> convertIndexResponse(IndexedDocumentResponse indexResponse) {
        if (!indexResponse.isStatusSuccess()) {
            if (indexResponse.getStatusCode() == 404 && indexResponse.getErrorType().isPresent() && ((String)indexResponse.getErrorType().get()).equals("index_not_found_exception")) {
                return Observable.error((Throwable)new ServiceUnavailableException("Index mappings do not exist yet and will be created automatically on the next search sync."));
            }
            return Observable.error((Throwable)new IndexException(String.format("Index response returned status code %s. Response: %s", indexResponse.getStatusCode(), indexResponse.toString())));
        }
        IndexResult.Builder resultBuilder = IndexResult.builder().created(indexResponse.created()).id(indexResponse.getId()).version(indexResponse.getVersion()).sequenceNumber(indexResponse.getSequenceNumber());
        return Observable.just((Object)resultBuilder.build());
    }

    private static Stream<BulkResponseItem> failedItems(BulkResponse response) {
        return response.getItems().stream().filter(item -> !item.isStatusSuccess());
    }

    private static String numbered(Iterator<String> lines) {
        StringBuilder sb = new StringBuilder();
        int number = 1;
        while (lines.hasNext()) {
            sb.append(number).append(" ").append(lines.next()).append("\n");
            ++number;
        }
        return sb.toString();
    }

    private BulkActionBuilder bulkDeleteAction(File file, RepositoryContextDefinition context) {
        String id = this.generateContentId(file, context);
        return ES.bulkDelete().id(id);
    }

    private BulkActionBuilder bulkIndexAction(File file, RepositoryContextDefinition context) {
        String id = this.generateContentId(file, context);
        String path = file.getPath();
        List extensions = Filenames.getExtensions(path).stream().map(StringValueContent::of).collect(Collectors.toList());
        ObjectContentBuilder sourceBuilder = ES.objectContent().with(FileMapping.PATH.fieldName(), file.getPath()).with(FileMapping.ARCHIVED.fieldName(), context.isArchived()).with(FileMapping.PUBLIC.fieldName(), context.isPublic()).with(FileMapping.FORK.fieldName(), context.isFork()).with(FileMapping.REPOSITORY_ID.fieldName(), (Number)context.getRepositoryId()).with(FileMapping.EXTENSION.fieldName(), (Content)ArrayContent.of(extensions)).with(FileMapping.FILENAME.fieldName(), Filenames.getFilename(path)).with(FileMapping.SIZE.fieldName(), (Number)file.getSize()).with(FileMapping.PROJECT_ID.fieldName(), (Number)context.getProjectId());
        if (file instanceof TextFile) {
            TextFile textFile = (TextFile)file;
            textFile.getContent().ifPresent(charSource -> {
                try (BufferedReader reader = charSource.openBufferedStream();){
                    sourceBuilder.with(FileMapping.CONTENT.fieldName(), IndexRequestDispatcher.numbered(reader.lines().iterator()));
                }
                catch (IOException e) {
                    log.error("Unable to read content from TextFile", (Throwable)e);
                }
            });
        }
        return ES.bulkIndex().id(id).source((ContentBuilder)sourceBuilder);
    }

    private FileRequestStatistics createIndexResultFromBatch(BulkResponse response, FileRequestStatistics.Builder statistics, Stopwatch stopwatch, List<String> documentIds) {
        this.updateStatistics(response, statistics, stopwatch, documentIds);
        FileRequestStatistics indexResult = statistics.build();
        if (log.isTraceEnabled()) {
            log.trace("Index progress: {}", (Object)indexResult);
        }
        return indexResult;
    }

    private Observable<RemoveResult> createRemoveResultFromBatch(BulkResponse response, RequestStatistics.Builder statistics, Stopwatch stopwatch, List<String> documentIds) {
        this.updateStatistics(response, statistics, stopwatch, documentIds);
        RemoveResult removeResult = RemoveResult.builder().requestStatistics(statistics.build()).build();
        if (log.isTraceEnabled()) {
            log.trace("Remove progress: {}", (Object)removeResult);
        }
        return Observable.just((Object)removeResult);
    }

    private UpdateResult createUpdateResultFromBatch(BulkResponse response, RequestStatistics.Builder statistics, Stopwatch stopwatch, List<String> documentIds) {
        this.updateStatistics(response, statistics, stopwatch, documentIds);
        UpdateResult updateResult = UpdateResult.builder().requestStatistics(statistics.build()).build();
        if (log.isTraceEnabled()) {
            log.trace("Update progress: {}", (Object)updateResult);
        }
        return updateResult;
    }

    private <T extends Response> Observable<T> executeHandleUnavailable(RequestBuilder<T> builder) {
        return SearchUtil.executeHandleUnavailable(this.client, builder);
    }

    private String generateContentId(File file, RepositoryContextDefinition context) {
        String potentialId = context.getRepositoryId() + DOCUMENT_ID_DELIMITER + file.getPath();
        if (potentialId.length() <= 512) {
            return potentialId;
        }
        log.debug("File path exceeds search ID max length, using hash instead. File: {}, Repository: {}", (Object)file.getPath(), (Object)context.getRepositoryId());
        byte[] hashBytes = this.digest.digest(file.getPath().getBytes(StandardCharsets.UTF_8));
        String hash = BaseEncoding.base16().lowerCase().encode(hashBytes);
        String truncatedId = StringUtils.truncate((String)potentialId, (int)(512 - hash.length() - 1));
        return truncatedId + DOCUMENT_ID_DELIMITER + hash;
    }

    private Date getRecentActivity(RepositoryPropertiesIndexRequest repositoryPropertiesIndexRequest) {
        Date recentActivity = repositoryPropertiesIndexRequest.getRecentActivity();
        if (recentActivity != null) {
            return recentActivity;
        }
        if (this.repositoryTimestampAccuracy == RepositoryTimestampAccuracy.ACCURATE) {
            return this.repositoryManagementService.getRecentActivity(repositoryPropertiesIndexRequest.getRepository());
        }
        return null;
    }

    private BulkActionBuilder toJson(File file, RepositoryContextDefinition context) {
        if (file.getChangeType() == ChangeType.DELETE) {
            return this.bulkDeleteAction(file, context);
        }
        return this.bulkIndexAction(file, context);
    }

    private List<BulkUpdateActionBuilder> transformDocumentIdsIntoUpdateActions(List<String> documentIds, RepositoryContextDefinition repositoryContextDefinition) {
        ArrayList<BulkUpdateActionBuilder> actions = new ArrayList<BulkUpdateActionBuilder>();
        for (String docId : documentIds) {
            ObjectContentBuilder doc = ES.objectContent().with(FileMapping.ARCHIVED.fieldName(), (Content)BooleanValueContent.of((boolean)repositoryContextDefinition.isArchived())).with(FileMapping.PUBLIC.fieldName(), (Content)BooleanValueContent.of((boolean)repositoryContextDefinition.isPublic())).with(FileMapping.PROJECT_ID.fieldName(), (Content)NumberValueContent.of((Number)repositoryContextDefinition.getProjectId()));
            ObjectContentBuilder src = ES.objectContent().with("doc", (ContentBuilder)doc);
            actions.add(ES.bulkUpdate().id(docId).source((ContentBuilder)src));
        }
        return actions;
    }

    private void updateStatistics(BulkResponse response, RequestStatistics.Builder statistics, Stopwatch stopwatch, List<String> documentIds) {
        stopwatch.stop();
        statistics.incrementTime(Duration.ofNanos(stopwatch.elapsed(TimeUnit.NANOSECONDS)));
        if (response.isStatusSuccess()) {
            IndexRequestDispatcher.failedItems(response).forEach(item -> {
                statistics.addFailedDocumentId(item.getId());
                if (log.isWarnEnabled()) {
                    if (item.getError().isPresent()) {
                        log.warn("Failed to index document with ID: {}: {}", (Object)item.getId(), item.getError().get());
                    } else {
                        log.warn("Failed to index document with ID: {}", (Object)item.getId());
                    }
                }
            });
            if (response.hasErrors()) {
                statistics.incrementNumPartiallyFailedRequests();
            }
        } else {
            statistics.incrementNumFailedRequests();
            documentIds.forEach(statistics::addFailedDocumentId);
            log.error("On next - expected status code 200 but got: {}", (Object)response.getStatusCode());
        }
    }
}

