/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.elasticsearch.client.document.SequenceNumber;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class IndexResult {
    private final boolean created;
    private final String id;
    private final SequenceNumber sequenceNumber;
    private final int version;

    private IndexResult(Builder builder) {
        this.created = builder.created;
        this.id = builder.id;
        this.version = builder.version;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public SequenceNumber getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isCreated() {
        return this.created;
    }

    public String toString() {
        return "IndexResult{created=" + this.created + ", id='" + this.id + "', sequenceNumber='" + String.valueOf(this.sequenceNumber) + "', version=" + this.version + "}";
    }

    public static final class Builder {
        private boolean created;
        private String id;
        private SequenceNumber sequenceNumber;
        private int version;

        private Builder() {
        }

        @Nonnull
        public IndexResult build() {
            return new IndexResult(this);
        }

        @Nonnull
        public Builder created(boolean val) {
            this.created = val;
            return this;
        }

        @Nonnull
        public Builder id(@Nonnull String val) {
            this.id = Objects.requireNonNull(val, "val");
            return this;
        }

        @Nonnull
        public Builder sequenceNumber(SequenceNumber val) {
            this.sequenceNumber = val;
            return this;
        }

        @Nonnull
        public Builder version(int val) {
            this.version = val;
            return this;
        }
    }
}

