/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryContextDefinition;
import com.atlassian.elasticsearch.client.document.SequenceNumber;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class IndexState {
    private final Instant claimTimestamp;
    private final String indexedCommitId;
    private final Instant indexedTimestamp;
    private final String indexingError;
    private final RepositoryContextDefinition repositoryContextDefinition;
    private final int retries;
    private final SequenceNumber sequenceNumber;
    private final String toCommitId;
    private final Long version;

    private IndexState(Builder builder) {
        this.claimTimestamp = builder.claimTimestamp;
        this.indexedCommitId = builder.indexedCommitId;
        this.indexedTimestamp = builder.indexedTimestamp;
        this.indexingError = builder.indexingError;
        this.repositoryContextDefinition = Objects.requireNonNull(builder.repositoryContextDefinition, "repositoryContextDefinition");
        this.retries = builder.retries;
        this.toCommitId = builder.toCommitId;
        this.version = builder.version;
        this.sequenceNumber = builder.sequenceNumber;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IndexState indexState) {
        return new Builder(indexState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexState that = (IndexState)o;
        return this.retries == that.retries && Objects.equals(this.claimTimestamp, that.claimTimestamp) && Objects.equals(this.indexedCommitId, that.indexedCommitId) && Objects.equals(this.indexedTimestamp, that.indexedTimestamp) && Objects.equals(this.indexingError, that.indexingError) && Objects.equals(this.repositoryContextDefinition, that.repositoryContextDefinition) && Objects.equals(this.sequenceNumber, that.sequenceNumber) && Objects.equals(this.toCommitId, that.toCommitId) && Objects.equals(this.version, that.version);
    }

    @Nonnull
    public Optional<Instant> getClaimTimestamp() {
        return Optional.ofNullable(this.claimTimestamp);
    }

    @Nonnull
    public Optional<String> getIndexedCommitId() {
        return Optional.ofNullable(this.indexedCommitId);
    }

    @Nonnull
    public Optional<Instant> getIndexedTimestamp() {
        return Optional.ofNullable(this.indexedTimestamp);
    }

    @Nonnull
    public Optional<String> getIndexingError() {
        return Optional.ofNullable(this.indexingError);
    }

    @Nonnull
    public RepositoryContextDefinition getRepositoryContextDefinition() {
        return this.repositoryContextDefinition;
    }

    public int getRetries() {
        return this.retries;
    }

    @Nonnull
    public Optional<SequenceNumber> getSequenceNumber() {
        return Optional.ofNullable(this.sequenceNumber);
    }

    @Nonnull
    public Optional<String> getToCommitId() {
        return Optional.ofNullable(this.toCommitId);
    }

    @Nonnull
    public OptionalLong getVersion() {
        return Optional.ofNullable(this.version).map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    public int hashCode() {
        return Objects.hash(this.claimTimestamp, this.indexedCommitId, this.indexedTimestamp, this.indexingError, this.repositoryContextDefinition, this.retries, this.toCommitId, this.sequenceNumber, this.version);
    }

    public String toString() {
        return "IndexState{claimTimestamp=" + String.valueOf(this.claimTimestamp) + ", indexedCommitId=" + this.indexedCommitId + ", indexedTimestamp=" + String.valueOf(this.indexedTimestamp) + ", indexingError=" + this.indexingError + ", repositoryContextDefinition=" + String.valueOf(this.repositoryContextDefinition) + ", retries=" + this.retries + ", sequenceNumber=" + String.valueOf(this.sequenceNumber) + ", toCommitId=" + this.toCommitId + ", version=" + this.version + "}";
    }

    public static class Builder {
        private Instant claimTimestamp;
        private String indexedCommitId;
        private Instant indexedTimestamp;
        private String indexingError;
        private RepositoryContextDefinition repositoryContextDefinition;
        private int retries;
        private SequenceNumber sequenceNumber;
        private String toCommitId;
        private Long version;

        private Builder() {
        }

        private Builder(IndexState indexState) {
            this.repositoryContextDefinition = indexState.repositoryContextDefinition;
            this.indexedCommitId = indexState.indexedCommitId;
            this.indexedTimestamp = indexState.indexedTimestamp;
            this.indexingError = indexState.indexingError;
            this.toCommitId = indexState.toCommitId;
            this.retries = indexState.retries;
            this.version = indexState.version;
            this.claimTimestamp = indexState.claimTimestamp;
            this.sequenceNumber = indexState.sequenceNumber;
        }

        @Nonnull
        public IndexState build() {
            return new IndexState(this);
        }

        @Nonnull
        public Builder claimTimestamp(Instant value) {
            this.claimTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder indexedCommitId(@Nonnull String value) {
            this.indexedCommitId = Objects.requireNonNull(value, "indexedCommitId");
            return this;
        }

        @Nonnull
        public Builder indexedTimestamp(Instant value) {
            this.indexedTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder indexingError(@Nullable String value) {
            this.indexingError = value;
            return this;
        }

        @Nonnull
        public Builder releaseClaim() {
            this.claimTimestamp = null;
            return this;
        }

        @Nonnull
        public Builder repositoryContextDefinition(@Nonnull RepositoryContextDefinition value) {
            this.repositoryContextDefinition = Objects.requireNonNull(value, "repositoryId");
            return this;
        }

        @Nonnull
        public Builder retries(int value) {
            this.retries = value;
            return this;
        }

        @Nonnull
        public Builder sequenceNumber(SequenceNumber value) {
            this.sequenceNumber = value;
            return this;
        }

        @Nonnull
        public Builder toCommitId(@Nullable String value) {
            this.toCommitId = value;
            return this;
        }

        @Nonnull
        public Builder version(long version) {
            this.version = version;
            return this;
        }
    }
}

