/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.client.Requests;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexStateMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryContextDefinition;
import com.atlassian.bitbucket.internal.search.common.mapping.SimpleRepositoryContextDefinition;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.AlreadyExistsException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.NotFoundException;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.VersionConflictException;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexState;
import com.atlassian.bitbucket.internal.search.indexing.util.SearchUtil;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.IndexTypeIdBuilder;
import com.atlassian.elasticsearch.client.content.ContentBuilder;
import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.content.ObjectContentBuilder;
import com.atlassian.elasticsearch.client.document.DeleteRequestBuilder;
import com.atlassian.elasticsearch.client.document.IndexRequestBuilder;
import com.atlassian.elasticsearch.client.request.RequestBuilder;
import com.atlassian.elasticsearch.client.request.Response;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component
public class IndexStateService {
    private final SearchClient client;

    @Autowired
    public IndexStateService(@Nonnull SearchClient client) {
        this.client = Objects.requireNonNull(client, "client");
    }

    public Observable<IndexState> delete(IndexState indexState) {
        DeleteRequestBuilder deleteRequestBuilder = IndexStateService.request(indexState.getRepositoryContextDefinition().getRepositoryId()).delete();
        indexState.getSequenceNumber().ifPresent(arg_0 -> ((DeleteRequestBuilder)deleteRequestBuilder).sequenceNumber(arg_0));
        return this.executeHandleUnavailable((RequestBuilder)deleteRequestBuilder).flatMap(response -> {
            if (response.getStatusCode() == 409) {
                return Observable.error((Throwable)new VersionConflictException(String.format("The request to delete state document for repository (id=%s) did not succeed. A version conflict occurred indicating that this delete is not acting upon the latest version of the document.", indexState.getRepositoryContextDefinition().getRepositoryId())));
            }
            if (!response.isStatusSuccess()) {
                return Observable.error((Throwable)new IndexException(String.format("Unexpected error occurred when requesting index state document (id=%s) the HTTP Status code is: %d", indexState.getRepositoryContextDefinition().getRepositoryId(), response.getStatusCode())));
            }
            return Observable.just((Object)IndexState.builder(indexState).build());
        });
    }

    public Observable<IndexState> load(int repositoryId) {
        return this.executeHandleUnavailable((RequestBuilder)IndexStateService.request(repositoryId).get()).flatMap(response -> {
            Optional source = response.getSource();
            if (response.getStatusCode() == 404 || !source.isPresent()) {
                return Observable.error((Throwable)new NotFoundException(String.format("The requested repository (id=%s) has no associated index state. This means that the repository create event was missed. Index state will be created.", repositoryId)));
            }
            if (!response.isStatusSuccess()) {
                return Observable.error((Throwable)new IndexException(String.format("Unexpected error occurred when requesting index state document (id=%s) The HTTP status code is: %d", repositoryId, response.getStatusCode())));
            }
            try {
                return Observable.just((Object)IndexStateService.deserialize(Integer.parseInt(response.getId()), (ObjectContent)source.get(), response.getVersion()));
            }
            catch (NumberFormatException e) {
                return Observable.error((Throwable)new IndexException(String.format("The repository id [%s] for repository (id=%s) is not a number.", response.getId(), repositoryId)));
            }
        });
    }

    public Observable<IndexState> save(IndexState indexState) {
        Instant indexedTimestamp = Instant.now();
        IndexRequestBuilder indexRequest = IndexStateService.request(indexState.getRepositoryContextDefinition().getRepositoryId()).index().source((ContentBuilder)IndexStateService.serialize(indexState, indexedTimestamp));
        boolean create = indexState.getVersion().isEmpty();
        indexRequest.create(create);
        indexState.getSequenceNumber().ifPresent(arg_0 -> ((IndexRequestBuilder)indexRequest).sequenceNumber(arg_0));
        return this.executeHandleUnavailable((RequestBuilder)indexRequest).flatMap(response -> {
            if (response.getStatusCode() == 409) {
                if (create) {
                    return Observable.error((Throwable)new AlreadyExistsException(String.format("The request to create index state document for repository (id=%s) did not succeed. A version conflict occurred indicating that a document has been created.", indexState.getRepositoryContextDefinition().getRepositoryId())));
                }
                return Observable.error((Throwable)new VersionConflictException(String.format("The request to save index state document for repository (id=%s) did not succeed. A version conflict occurred indicating that an update has been performed to the document since it was last seen by this client.", indexState.getRepositoryContextDefinition().getRepositoryId())));
            }
            if (!response.isStatusSuccess()) {
                return Observable.error((Throwable)new IndexException(String.format("Unexpected error occurred when requesting index state document (id=%s) the HTTP Status code is: %d", indexState.getRepositoryContextDefinition().getRepositoryId(), response.getStatusCode())));
            }
            return Observable.just((Object)IndexState.builder(indexState).version(response.getVersion()).sequenceNumber(response.getSequenceNumber()).indexedTimestamp(indexedTimestamp).build());
        });
    }

    private static IndexTypeIdBuilder request(int repositoryId) {
        return Requests.request(IndexStateMapping.type()).id(String.valueOf(repositoryId));
    }

    private static IndexState deserialize(int repositoryId, ObjectContent source, long version) {
        SimpleRepositoryContextDefinition.Builder ctxBuilder = SimpleRepositoryContextDefinition.builder();
        ctxBuilder.repositoryId(repositoryId);
        Optional projectId = source.getNumber(IndexStateMapping.PROJECT_ID.fieldName());
        projectId.ifPresent(id -> ctxBuilder.projectId(id.intValue()));
        Optional isPublic = source.getBoolean(IndexStateMapping.PUBLIC.fieldName());
        isPublic.ifPresent(ctxBuilder::isPublic);
        Optional isFork = source.getBoolean(IndexStateMapping.FORK.fieldName());
        isFork.ifPresent(ctxBuilder::isFork);
        RepositoryContextDefinition updatedCtx = ctxBuilder.build();
        IndexState.Builder builder = IndexState.builder().repositoryContextDefinition(updatedCtx).version(version);
        Optional indexedCommitId = source.getString(IndexStateMapping.INDEXED_COMMIT_ID.fieldName());
        indexedCommitId.ifPresent(builder::indexedCommitId);
        Optional toCommitId = source.getString(IndexStateMapping.TO_COMMIT_ID.fieldName());
        toCommitId.ifPresent(builder::toCommitId);
        int retries = ((Number)source.getNumber(IndexStateMapping.RETRIES.fieldName()).orElse(0)).intValue();
        builder.retries(retries);
        Optional claimedAt = source.getNumber(IndexStateMapping.CLAIM_TIMESTAMP.fieldName());
        claimedAt.map(instant -> builder.claimTimestamp(Instant.ofEpochMilli(instant.longValue())));
        Optional indexedTimestamp = source.getNumber(IndexStateMapping.INDEXED_TIMESTAMP.fieldName());
        indexedTimestamp.map(instant -> builder.indexedTimestamp(Instant.ofEpochMilli(instant.longValue())));
        return builder.build();
    }

    private <T extends Response> Observable<T> executeHandleUnavailable(RequestBuilder<T> builder) {
        return SearchUtil.executeHandleUnavailable(this.client, builder);
    }

    private static ObjectContentBuilder serialize(IndexState indexState, Instant indexedTimestamp) {
        ObjectContentBuilder builder = ES.objectContent().with(IndexStateMapping.ARCHIVED.fieldName(), indexState.getRepositoryContextDefinition().isArchived()).with(IndexStateMapping.PUBLIC.fieldName(), indexState.getRepositoryContextDefinition().isPublic()).with(IndexStateMapping.FORK.fieldName(), indexState.getRepositoryContextDefinition().isFork()).with(IndexStateMapping.RETRIES.fieldName(), (Number)indexState.getRetries()).with(IndexStateMapping.PROJECT_ID.fieldName(), (Number)indexState.getRepositoryContextDefinition().getProjectId());
        indexState.getIndexedCommitId().ifPresent(cid -> builder.with(IndexStateMapping.INDEXED_COMMIT_ID.fieldName(), cid));
        indexState.getToCommitId().ifPresent(toCommitId -> builder.with(IndexStateMapping.TO_COMMIT_ID.fieldName(), toCommitId));
        indexState.getClaimTimestamp().ifPresent(instant -> builder.with(IndexStateMapping.CLAIM_TIMESTAMP.fieldName(), (Number)instant.toEpochMilli()));
        return IndexStateService.setIndexedTimestamp(builder, indexedTimestamp);
    }

    private static ObjectContentBuilder setIndexedTimestamp(ObjectContentBuilder builder, Instant indexedTimestamp) {
        return builder.with(IndexStateMapping.INDEXED_TIMESTAMP.fieldName(), (Number)indexedTimestamp.toEpochMilli());
    }
}

