/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingSettings {
    public static final String CLAIM_DURATION_KEY = "search.indexing.claim.duration";
    public static final int DEFAULT_ACTIONS_PER_BULK_REQUEST = 1000;
    public static final int DEFAULT_BATCH_CONTENT_BYTES = 0xF00000;
    public static final Duration DEFAULT_CLAIM_DURATION = Duration.ofMinutes(15L);
    public static final int DEFAULT_OPERATION_RETRIES = 5;
    public static final String MAX_ACTIONS_PER_BATCH_REQUEST_KEY = "search.indexing.max.batch.items";
    public static final int MAX_ACTIONS_PER_BULK_REQUEST = 10240;
    public static final int MAX_BATCH_CONTENT_BYTES = 0x6400000;
    public static final String MAX_BATCH_CONTENT_SIZE_KEY = "search.indexing.max.batch.size";
    public static final Duration MAX_CLAIM_DURATION = Duration.ofHours(12L);
    public static final int MAX_OPERATION_RETRIES = 1000;
    public static final int MIN_ACTIONS_PER_BULK_REQUEST = 1;
    public static final int MIN_BATCH_CONTENT_BYTES = 1024;
    public static final Duration MIN_CLAIM_DURATION = Duration.ofSeconds(30L);
    public static final int MIN_OPERATION_RETRIES = 1;
    public static final String OPERATION_RETRIES_KEY = "search.indexing.operation.retries";
    private static final Logger log = LoggerFactory.getLogger(IndexingSettings.class);
    private final int batchContentSizeBytes;
    private final Duration claimDuration;
    private final int indexRetries;
    private final int itemsPerBatch;

    protected IndexingSettings(Builder builder) {
        this.batchContentSizeBytes = builder.batchContentSizeBytes;
        this.claimDuration = builder.claimDuration;
        this.indexRetries = builder.indexRetries;
        this.itemsPerBatch = builder.itemsPerBatch;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnegative
    public int getBatchContentSizeBytes() {
        return this.batchContentSizeBytes;
    }

    @Nonnull
    public Duration getClaimDuration() {
        return this.claimDuration;
    }

    @Nonnegative
    public int getIndexRetries() {
        return this.indexRetries;
    }

    @Nonnegative
    public int getItemsPerBatch() {
        return this.itemsPerBatch;
    }

    public static class Builder {
        private int batchContentSizeBytes = 0xF00000;
        private Duration claimDuration = DEFAULT_CLAIM_DURATION;
        private int indexRetries = 5;
        private int itemsPerBatch = 1000;

        @Nonnull
        public Builder batchContentSizeBytes(@Nonnegative int value) {
            this.batchContentSizeBytes = Builder.requireValueBetween(value, 1024, 0x6400000, "batchContentSizeBytes");
            return this;
        }

        @Nonnull
        public IndexingSettings build() {
            return new IndexingSettings(this);
        }

        @Nonnull
        public Builder claimDuration(@Nonnull @Nonnegative Duration value) {
            this.claimDuration = Builder.requireValidClaimDuration(value);
            return this;
        }

        @Nonnull
        public Builder indexRetries(@Nonnegative int value) {
            this.indexRetries = Builder.requireValueBetween(value, 1, 1000, "indexRetries");
            return this;
        }

        @Nonnull
        public Builder itemsPerBatch(@Nonnegative int value) {
            this.itemsPerBatch = Builder.requireValueBetween(value, 1, 10240, "itemsPerBatch");
            return this;
        }

        private static Duration requireValidClaimDuration(Duration value) {
            Duration maybeValid = Objects.requireNonNull(value, "claimDuration");
            if (maybeValid.isZero() || maybeValid.isNegative()) {
                log.warn("claimDuration cannot be zero or less, but was " + String.valueOf(value) + ". Using default minimum of " + String.valueOf(MIN_CLAIM_DURATION));
                return MIN_CLAIM_DURATION;
            }
            if (maybeValid.compareTo(MIN_CLAIM_DURATION) < 0) {
                log.warn("claimDuration is too small, cannot be less than: " + String.valueOf(MIN_CLAIM_DURATION) + ", but was " + String.valueOf(value) + ". Using default minimum of " + String.valueOf(MIN_CLAIM_DURATION));
                return MIN_CLAIM_DURATION;
            }
            if (maybeValid.compareTo(MAX_CLAIM_DURATION) > 0) {
                log.warn("claimDuration is too large, cannot be greater than: " + String.valueOf(MAX_CLAIM_DURATION) + ", but was " + String.valueOf(value) + ". Using default maximum of " + String.valueOf(MAX_CLAIM_DURATION));
                return MAX_CLAIM_DURATION;
            }
            return value;
        }

        private static int requireValueBetween(int value, int start, int end, String argumentName) {
            if (value < start) {
                log.warn(argumentName + " must be between " + start + " and " + end + " inclusive, but was " + value + ". Using default minimum value of " + start);
                return start;
            }
            if (value > end) {
                log.warn(argumentName + " must be between " + start + " and " + end + " inclusive, but was " + value + ". Using default maximum value of " + end);
                return end;
            }
            return value;
        }
    }
}

